/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "polytool.h"

#include "model.h"
#include "msg.h"
#include "log.h"
#include "modelstatus.h"

#include "pixmap/polytool.xpm"

PolyTool::PolyTool()
   : m_model( NULL ),
     m_vertexId( -1 ),
     m_isFan( false ),
     m_widget( NULL )
{
}

PolyTool::~PolyTool()
{
}

void PolyTool::activated( int arg, Model * model, QMainWindow * mainwin )
{
   m_model = model;
   m_widget = new PolyToolWidget( (PolyToolWidget::Observer *) this, (QWidget *) mainwin );
#ifdef HAVE_QT4
   //mainwin->addDockWindow( m_widget, DockBottom );
#endif
   m_widget->show();
}

void PolyTool::deactivated()
{
   m_model->deleteOrphanedVertices();
   m_widget->close();
}

void PolyTool::mouseButtonDown( Parent * parent, int buttonState, int x, int y )
{
   Model * model = parent->getModel();

   m_model = model;

   if ( buttonState == BS_Left )
   {
      m_verts.clear();

      IntList selected = model->getSelectedVertices();
      IntList::iterator it;
      for ( it = selected.begin(); m_verts.size() < 3 && it != selected.end(); it++ )
      {
         m_verts.push_back( *it );
      }

      double coord[3] = {0,0,0};

      parent->getXValue( x, y, &coord[0] );
      parent->getYValue( x, y, &coord[1] );
      parent->getZValue( x, y, &coord[2] );

      m_vertexId = model->addVertex( coord[0], coord[1], coord[2] );
      model->selectVertex( m_vertexId );

      if ( m_verts.size() == 3 )
      {
         if ( m_isFan )
         {
            it = m_verts.begin();
            it++;
            int v = *it;
            m_verts.erase( it );
            model->unselectVertex( v );

            m_verts.push_back( m_vertexId );
         }
         else
         {
            int v = m_verts.front();
            model->unselectVertex( v );

            m_verts.pop_front();
            m_verts.push_back( m_vertexId );
         }
      }
      else
      {
         m_verts.push_back( m_vertexId );
      }

      if ( m_verts.size() == 3 )
      {
         it = m_verts.begin();
         int v1 = *it; it++;
         int v2 = *it; it++;
         int v3 = *it; it++;

         int t = model->addTriangle( v1, v2, v3 );
         model->unselectAllTriangles();
         model->selectTriangle( t );

         model_status( model, StatusNormal, STATUSTIME_SHORT, "Press the right mouse button to invert normals" );
      }

      parent->updateAllViews();
   }
   else
   {
      int t = model->getTriangleCount() - 1;
      while ( t >= 0 )
      {
         if ( model->isTriangleSelected( t ) )
         {
            model->invertNormals( t );
            parent->updateAllViews();
            break;
         }
      }
   }
}

void PolyTool::mouseButtonMove( Parent * parent, int buttonState, int x, int y )
{
   if ( buttonState == BS_Left )
   {
      if ( m_vertexId >= 0 )
      {
         double coord[3] = {0,0,0};

         parent->getXValue( x, y, &coord[0] );
         parent->getYValue( x, y, &coord[1] );
         parent->getZValue( x, y, &coord[2] );

         parent->getModel()->moveVertex( m_vertexId, coord[0], coord[1], coord[2] );

         parent->updateAllViews();
      }
   }
}

void PolyTool::mouseButtonUp( Parent * parent, int buttonState, int x, int y )
{
}

const char ** PolyTool::getPixmap()
{
   return (const char **) polytool_xpm;
}

void PolyTool::setFanValue( bool newValue )
{
   m_isFan = newValue;
   log_debug( "isFan = %s\n", newValue ? "true" : "false" );
}

