/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */

#ifdef WIN32

#ifndef __MM3DREG_H
#define __MM3DREG_H

#include <windows.h>
#include <string>
#include <vector>

namespace Mm3dReg
{

enum RegAccess_e 
{
    RA_READ,
    RA_WRITE,
    RA_ALL,
};
typedef enum RegAccess_e RegAccess;

enum RegError_e 
{
    RE_NONE,
    RE_NO_KEY,
    RE_ACCESS_DENIED,
    RE_INVALID_HANDLE,
    RE_WRONG_TYPE,
    RE_UNKNOWN,
};
typedef enum RegError_e RegError;

typedef std::vector< std::string > RegStringList;

class Mm3dRegKey
{
    public:
        Mm3dRegKey( HKEY hKey, const char * subKey, RegAccess ra = RA_ALL );
        virtual ~Mm3dRegKey( );

        //-------------------------------------------------------
        // Static convenience functions
        //
        static RegError winToMm3dError( LONG err );

        static RegError deleteKey( HKEY hkey, const char * keyName );

        // Get a single value
        static int getRegistryInt( HKEY hKey, const char * subKey, const char * valueName );
        static std::string getRegistryString( HKEY hKey, const char * subKey, const char * valueName );
        
        // Set a single value
        static RegError setRegistryInt( HKEY hKey, const char * subKey, const char * valueName, int val );
        static RegError setRegistryString( HKEY hKey, const char * subKey, const char * valueName, const std::string & val );

        //-------------------------------------------------------
        // Member functions
        //
        RegError deleteSubKey( const char * keyName );
        RegError deleteValue( const char * valueName );

        HKEY getHKey() const { return m_hkey; };

        RegError getLastError() const { return m_error; };

        RegError getValueType( const char * value, DWORD & valueType );
        RegError getValueString( const char * value, std::string & valueStr );
        RegError getValueInt( const char * value, int & valueInt );

        RegError setValueString( const char * value, const std::string & valueStr );
        RegError setValueInt( const char * value, int valueInt );

        RegError getValueNames(  RegStringList & nameList );
        RegError getSubKeyNames( RegStringList & nameList );

    protected:

        RegError openKey( HKEY hKey, const char * subKey, RegAccess ra );

        RegError m_error;

        HKEY m_hkey;
};

};

#endif // __MM3DREG_H

#endif // WIN32
