/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "flipcmd.h"

#include "model.h"
#include "log.h"
#include "msg.h"
#include "modelstatus.h"

#include <list>

using std::list;

FlipCommand::FlipCommand()
{
}

FlipCommand::~FlipCommand()
{
}

const char * FlipCommand::getName( int arg )
{
   switch ( arg )
   {
      case 0:
         return "Flip";
         break;
      case 1:
         return "Flip X";
         break;
      case 2:
         return "Flip Y";
         break;
      case 3:
         return "Flip Z";
         break;
      default:
         break;
   }

   return "[Out of range]";
}

bool FlipCommand::activated( int arg, Model * model )
{
   int index;

   index = arg - 1;

   // Check for index out of range
   if ( index < 0 || index > 2 )
   {
      log_error( "flip on index %d out of range", index );
      return false;
   }

   list<int> vert   = model->getSelectedVertices();
   list<int> joints = model->getSelectedBoneJoints();

   if ( vert.empty() && joints.empty() )
   {
      model_status( model, StatusError, STATUSTIME_LONG, "Need at least 1 vertex, joint, or face selected" );
      return false;
   }

   list<int>::iterator it;
   for ( it = vert.begin(); it != vert.end(); it++ )
   {
      double coords[3];
      model->getVertexCoords( *it, coords );
      coords[index] = -coords[index];
      model->moveVertex( *it, coords[0], coords[1], coords[2] );
   }

   for ( it = joints.begin(); it != joints.end(); it++ )
   {
      double coords[3];
      model->getBoneJointCoords( *it, coords );
      coords[index] = -coords[index];
      model->moveBoneJoint( *it, coords[0], coords[1], coords[2] );
   }

   list<int> face = model->getSelectedTriangles();

   for ( it = face.begin(); it != face.end(); it++ )
   {
      model->invertNormals( *it );
   }

   model_status( model, StatusNormal, STATUSTIME_SHORT, "Selected primitives flipped" );

   return true;
}

