// ChildFrm.cpp : implementation of the CChildFrame class
// 

#include "stdafx.h"
#include "MedDLe.h"

#include "ChildFrm.h"
#include "CameraView.h"
#include "2DView.h"
#include "MainFrm.h"
#include "CameraDlg.h"
#include "Anim.h"
#include "RotateTool.h"
#include "ScaleTool.h"
#include "FrameTool.h"
#include "BonesTool.h"
#include "PrimativeTool.h"
#include "SelectionTool.h"
#include "GridTool.h"
#include "GroupTool.h"
#include "VertTool.h"
#include "TriTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CChildFrame

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CChildFrame)
	ON_COMMAND(ID_BUTTON_RESIZE, OnButtonResize)
	ON_COMMAND(ID_BUTTON_ZOOM, OnButtonZoom)
	ON_COMMAND(ID_BUTTON_CAMERA, OnButtonCamera)
	ON_COMMAND(ID_BUTTON_GRID, OnButtonGrid)
	ON_COMMAND(ID_VIEW_CAMDLG, OnViewCamdlg)
	ON_COMMAND(ID_OGV_GROUP, OnOgvGroup)
	ON_COMMAND(ID_OGV_OBJECT, OnOgvObject)
	ON_COMMAND(ID_OGV_VERTEX, OnOgvVertex)
	ON_WM_MDIACTIVATE()
	ON_COMMAND(ID_EDIT_INVERT, OnEditInvert)
	ON_COMMAND(ID_EDIT_HIDESELECTED, OnEditHideselected)
	ON_COMMAND(ID_EDIT_SHOWALL, OnEditShowall)
	ON_UPDATE_COMMAND_UI(ID_OGV_GROUP, OnUpdateOgvGroup)
	ON_UPDATE_COMMAND_UI(ID_OGV_OBJECT, OnUpdateOgvObject)
	ON_UPDATE_COMMAND_UI(ID_OGV_VERTEX, OnUpdateOgvVertex)
	ON_UPDATE_COMMAND_UI(ID_BUTTON_ZOOM, OnUpdateButtonZoom)
	ON_UPDATE_COMMAND_UI(ID_BUTTON_NONE, OnUpdateButtonNone)
	ON_UPDATE_COMMAND_UI(ID_BUTTON_ROTATE, OnUpdateButtonRotate)
	ON_UPDATE_COMMAND_UI(ID_BUTTON_SCALE, OnUpdateButtonScale)
	ON_COMMAND(ID_BUTTON_NONE, OnButtonNone)
	ON_COMMAND(ID_BUTTON_ROTATE, OnButtonRotate)
	ON_COMMAND(ID_BUTTON_SCALE, OnButtonScale)
	ON_COMMAND(ID_DEL_SEL, OnDelSel)
	ON_COMMAND(ID_FLIP_SEL, OnFlipSel)
	ON_COMMAND(ID_CLONE_SEL, OnCloneSel)
	ON_COMMAND(ID_OGV_TRI, OnOgvTri)
	ON_UPDATE_COMMAND_UI(ID_OGV_TRI, OnUpdateOgvTri)
	ON_COMMAND(ID_TOGGLESKELMODE, OnToggleskelmode)
	ON_COMMAND(ID_OGV_SKEL, OnOgvSkel)
	ON_UPDATE_COMMAND_UI(ID_OGV_SKEL, OnUpdateOgvSkel)
	ON_UPDATE_COMMAND_UI(ID_BUTTON_GRID, OnUpdateButtonGrid)
	//}}AFX_MSG_MAP
	// Standard printing commands
//	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
//	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
//	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame construction/destruction

CChildFrame::CChildFrame()
{
}

CChildFrame::~CChildFrame()
{
}

BOOL CChildFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	return CMDIChildWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame diagnostics

#ifdef _DEBUG
void CChildFrame::AssertValid() const
{
	CMDIChildWnd::AssertValid();
}

void CChildFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers

BOOL CChildFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	if (!m_wndSplitter.CreateStatic(this, 2, 2))//, WS_CHILD | WS_VISIBLE | WS_BORDER))
	{
		return FALSE;
	}
	if (!m_wndSplitter.CreateView(1, 1,	RUNTIME_CLASS(CCameraView), CSize(100, 100), pContext))
	{
		return FALSE;
	}

	if (!m_wndSplitter.CreateView(0, 0, RUNTIME_CLASS(C2DView), CSize(100, 100), pContext))
	{
		return FALSE;
	}
	if (!m_wndSplitter.CreateView(0, 1, RUNTIME_CLASS(C2DView), CSize(100, 100), pContext))
	{
		return FALSE;
	}

	if (!m_wndSplitter.CreateView(1, 0, RUNTIME_CLASS(C2DView), CSize(100, 100), pContext))
	{
		return FALSE;
	}

	OnButtonResize();

	return TRUE;
}

void CChildFrame::OnButtonResize() 
{
	CRect rc;
	GetClientRect(&rc);
	int x;
	x=rc.bottom/2-5;
	if(x<0) x=0;
	m_wndSplitter.SetRowInfo( 0, x, 0 );
	x=rc.right/2-5; if(x<0) x=0;
	m_wndSplitter.SetColumnInfo( 0, x, 0 );
	m_wndSplitter.RecalcLayout();
}


void CChildFrame::OnButtonGrid() 
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	if(pDoc==NULL) return;

	if (pDoc->m_Grid.bVisible) pDoc->m_Grid.bVisible=0;
	else pDoc->m_Grid.bVisible=1;

	pDoc->UpdateAllViews(NULL);
}
void CChildFrame::OnUpdateButtonGrid(CCmdUI* pCmdUI) 
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	pCmdUI->SetCheck(pDoc->m_Grid.bVisible);
}


void CChildFrame::OnButtonCamera() 
{
	OnViewCamdlg();
}

void CChildFrame::OnViewCamdlg()
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	
	CCameraDlg CDlg(this);
	int t,v,bc,fb,sc,pc;

/*	CDlg.pdoc=pDoc;
	if (pDoc->Rflags&R_FB) fb=1;
	else fb=0;
	CDlg.m_FrontBack=fb;
	CDlg.viewmode=pDoc->fill_mode;
	CDlg.spot_int=pDoc->light_intensity;
	CDlg.amb_int=pDoc->ambient_intensity;
	if (pDoc->Rflags&R_WIRE) t=1;
	else t=0;
	CDlg.m_Tris=t;
	if (pDoc->Rflags&R_VERT) v=1;
	else v=0;
	CDlg.m_Verts=v;
	bc=pDoc->back_color;
	CDlg.m_BackC=bc;
	sc=pDoc->tcolor;
	CDlg.m_ShirtC=sc;
	pc=pDoc->bcolor;
	CDlg.m_PantsC=pc;
	
	if(CDlg.DoModal()!=IDOK)
	{
		pDoc->fill_mode=CDlg.viewmode;
		pDoc->light_intensity=CDlg.spot_int;
		pDoc->ambient_intensity=CDlg.amb_int;
		pDoc->tcolor=sc;
		pDoc->bcolor=pc;
		if (t==1) pDoc->Rflags |= R_WIRE;
		else pDoc->Rflags &= ~R_WIRE;
		if (v==1) pDoc->Rflags |= R_VERT;
		else pDoc->Rflags &= ~R_VERT;
		pDoc->back_color=bc;
		if (fb==1) pDoc->Rflags |= R_FB;
		else pDoc->Rflags &= ~R_FB;
		pDoc->UpdateAllViews(NULL);
	}
*/	
}

void CChildFrame::OnOgvGroup() 
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
	theApp.m_AppMode=AM_GROUP;

	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL, FALSE);
	pDoc->AutoCreateColors(*pDoc->m_MedDLeObject.m_BaseFrame);
	pDoc->UpdateAllViews(NULL);
}

void CChildFrame::OnOgvObject() 
{

AfxMessageBox("todo");
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX, FALSE);
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI, FALSE);
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP, FALSE);
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT);
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL, FALSE);
//	pDoc->EditMode = SM_OBJECT;
	pDoc->AutoCreateColors(*pDoc->m_MedDLeObject.m_BaseFrame);
	pDoc->UpdateAllViews(NULL);
}

void CChildFrame::OnOgvVertex() 
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL, FALSE);
	theApp.m_AppMode=AM_VERT;
//	pDoc->EditMode = SM_VERT;
	pDoc->AutoCreateColors(*pDoc->m_MedDLeObject.m_BaseFrame);
	pDoc->UpdateAllViews(NULL);
}

void CChildFrame::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd) 
{
	CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);

	if (bActivate == TRUE) 
	{
		CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
		theApp.m_pActiveDoc=pDoc;
		CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
		Main->RefreshToolBar();
		
		// update tool dlgs
/*		if(Main->m_tGroup.IsWindowVisible())
			Main->m_tGroup.ShowWindow(SW_SHOWNA);
		if(Main->m_tGrid.IsWindowVisible())
			Main->m_tGrid.ShowWindow(SW_SHOWNA);
		if(Main->m_tFrame.IsWindowVisible())
			Main->m_tFrame.ShowWindow(SW_SHOWNA);
		if(Main->m_tPrimative.IsWindowVisible())
			Main->m_tPrimative.ShowWindow(SW_SHOWNA);
*///		if(Main->m_tAnimate.IsWindowVisible())
	//		Main->m_tAnimate.ShowWindow(SW_SHOWNA);

	}

	else 	theApp.m_pActiveDoc=NULL;

	// update anything else

//	if (pDoc->Rflags&R_GRID) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_BUTTON_GRID);
//		else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_BUTTON_GRID, FALSE);
//	}

/*	if (bActivate == TRUE) {
		CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
		CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
		theApp.m_pActiveDoc=pDoc;
		if((pDoc->AnimationPlaying)&&(theApp.AnimDlgOn))
		{
			pDoc->AnimationPlaying=0;
			KillTimer(1);
			theApp.m_pAnimDlg->m_PlayAnim.SetIcon(theApp.m_pAnimDlg->Iplay);

			theApp.m_pAnimDlg->m_AnimName = pDoc->Animations[pDoc->cur.animation].name;
			
			theApp.m_pAnimDlg->UpdateData(0);

		}
//		theApp.m_pProjectMan->UpdateProjectMan(NULL);
		if (pDoc->EditMode == SM_VERT){
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL, FALSE);
		} else if (pDoc->EditMode == SM_TRI) {
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL, FALSE);
		} else if (pDoc->EditMode == SM_GROUP) {
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL, FALSE);
		} else if (pDoc->EditMode == SM_OBJECT) {
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL, FALSE);
		} else if (pDoc->EditMode == SM_OBJECT) {
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI, FALSE);
			Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL);
		}

		if (theApp.m_AppAction==AA_ZOOM) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_BUTTON_ZOOM);
		else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_BUTTON_ZOOM, FALSE);

		if (pDoc->Rflags&R_GRID) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_BUTTON_GRID);
		else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_BUTTON_GRID, FALSE);

		if (pDoc->Restrict[0] == TRUE) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_XLOCK);
		else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_XLOCK, FALSE);
		if (pDoc->Restrict[1] == TRUE) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_YLOCK);
		else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_YLOCK, FALSE);
		if (pDoc->Restrict[2] == TRUE) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_ZLOCK);
		else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_ZLOCK, FALSE);
	
	} else {
		if (pActivateWnd==NULL){
			theApp.m_pActiveDoc=NULL;
//			theApp.m_pProjectMan->UpdateProjectMan(NULL);
		} 
	}
	*/
}

/*void CChildFrame::OnXyzXlock() 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
//	pDoc->Restrict[0] = !pDoc->Restrict[0];
//	if (pDoc->Restrict[0] == TRUE) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_XLOCK);
//	else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_XLOCK, FALSE);
}

void CChildFrame::OnXyzYlock() 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
//	pDoc->Restrict[1] = !pDoc->Restrict[1];
//	if (pDoc->Restrict[1] == TRUE) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_YLOCK);
//	else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_YLOCK, FALSE);
}

void CChildFrame::OnXyzZlock() 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
//	pDoc->Restrict[2] = !pDoc->Restrict[2];
//	if (pDoc->Restrict[2] == TRUE) Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_ZLOCK);
//	else Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_XYZ_ZLOCK, FALSE);
}
*/
void CChildFrame::OnEditInvert() 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	int i;
//	switch (pDoc->EditMode){
/*		case SM_VERT: 
			for (i=0; i<pDoc->Verts.GetSize(); i++){
				if (!(pDoc->Verts[i].flags & O_HIDDEN)){
					if (pDoc->Verts[i].flags & O_SELECTED) pDoc->Verts[i].flags -= O_SELECTED;
					else pDoc->Verts[i].flags += O_SELECTED;
				}
			}
			break;
		case SM_TRI: 
			for (i=0; i<pDoc->Tris.GetSize(); i++){
				if (!(pDoc->Tris[i].Vflags & O_HIDDEN)){
					if (pDoc->Tris[i].Vflags & O_SELECTED) pDoc->Tris[i].Vflags -= O_SELECTED;
					else pDoc->Tris[i].Vflags += O_SELECTED;
				}
			}
			break;
		case SM_GROUP: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				for (int k=0; k<pDoc->Objects[i].Groups.GetSize(); k++){
					if (!(pDoc->Objects[i].Groups[k]->flags & O_HIDDEN)){
						if (pDoc->Objects[i].Groups[k]->flags & O_SELECTED) pDoc->Objects[i].Groups[k]->flags -= O_SELECTED;
						else pDoc->Objects[i].Groups[k]->flags += O_SELECTED;
					}
				}
			}
			break;
		case SM_OBJECT: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				if (!(pDoc->Objects[i].flags & O_HIDDEN)){
					if (pDoc->Objects[i].flags & O_SELECTED) pDoc->Objects[i].flags -= O_SELECTED;
					else pDoc->Objects[i].flags += O_SELECTED;
				}
			}
			break;
		case SM_SKEL: 
			for (i=0; i<pDoc->Skeleton.cnt; i++){
				if (!(pDoc->Skeleton.hflags[i] & O_HIDDEN)){
					if (pDoc->Skeleton.hflags[i] & O_SELECTED) pDoc->Skeleton.hflags[i] -= O_SELECTED;
					else pDoc->Skeleton.hflags[i] += O_SELECTED;
				}
				if (!(pDoc->Skeleton.tflags[i] & O_HIDDEN)){
					if (pDoc->Skeleton.tflags[i] & O_SELECTED) pDoc->Skeleton.tflags[i] -= O_SELECTED;
					else pDoc->Skeleton.tflags[i] += O_SELECTED;
				}
			}
			break;
	}
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
	*/
}

//void CChildFrame::OnEditSelectall() 
//{
/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	int i;
	switch (pDoc->EditMode){
		case SM_VERT: 
			for (i=0; i<pDoc->Verts.GetSize(); i++){ 
				if (!(pDoc->Verts[i].flags & O_HIDDEN)) pDoc->Verts[i].flags |= O_SELECTED; 
			}
			break;
		case SM_TRI: 
			for (i=0; i<pDoc->Tris.GetSize(); i++){
				if (!(pDoc->Tris[i].Vflags & O_HIDDEN)) pDoc->Tris[i].Vflags |= O_SELECTED; 
			}
			break;
		case SM_GROUP: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				for (int k=0; k<pDoc->Objects[i].Groups.GetSize(); k++){
					if (!(pDoc->Objects[i].Groups[k]->flags & O_HIDDEN)) pDoc->Objects[i].Groups[k]->flags |= O_SELECTED; 
				}
			}
			break;
		case SM_OBJECT: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				if (!(pDoc->Objects[i].flags & O_HIDDEN)) pDoc->Objects[i].flags |= O_SELECTED; 
			}
			break;
		case SM_SKEL: 
			for (i=0; i<pDoc->Skeleton.cnt; i++){
				if (!(pDoc->Skeleton.hflags[i] & O_HIDDEN)) pDoc->Skeleton.hflags[i] |= O_SELECTED; 
				if (!(pDoc->Skeleton.tflags[i] & O_HIDDEN)) pDoc->Skeleton.tflags[i] |= O_SELECTED; 
			}
			break;
	}
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
	*/
//}

//void CChildFrame::OnEditSelectnone() 
//{
/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	int i;
	switch (pDoc->EditMode){
		case SM_VERT: 
			for (i=0; i<pDoc->Verts.GetSize(); i++){ 
				if (!(pDoc->Verts[i].flags & O_HIDDEN)) pDoc->Verts[i].flags &=~O_SELECTED; 
			}
			break;
		case SM_TRI: 
			for (i=0; i<pDoc->Tris.GetSize(); i++){
				if (!(pDoc->Tris[i].Vflags & O_HIDDEN)) pDoc->Tris[i].Vflags &=~O_SELECTED; 
			}
			break;
		case SM_GROUP: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				for (int k=0; k<pDoc->Objects[i].Groups.GetSize(); k++){
					if (!(pDoc->Objects[i].Groups[k]->flags & O_HIDDEN)) pDoc->Objects[i].Groups[k]->flags &=~O_SELECTED; 
				}
			}
			break;
		case SM_OBJECT: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				if (!(pDoc->Objects[i].flags & O_HIDDEN)) pDoc->Objects[i].flags &=~O_SELECTED; 
			}
			break;
		case SM_SKEL: 
			for (i=0; i<pDoc->Skeleton.cnt; i++){
				if (!(pDoc->Skeleton.hflags[i] & O_HIDDEN)) pDoc->Skeleton.hflags[i] &=~O_SELECTED; 
				if (!(pDoc->Skeleton.tflags[i] & O_HIDDEN)) pDoc->Skeleton.tflags[i] &=~O_SELECTED; 
			}
			break;
	}
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
*/
//}

void CChildFrame::OnEditHideselected() 
{
/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	int i;
	switch (pDoc->EditMode){
		case SM_VERT: 
			for (i=0; i<pDoc->Verts.GetSize(); i++){ 
				if ((!(pDoc->Verts[i].flags & O_HIDDEN)) && (pDoc->Verts[i].flags & O_SELECTED)) pDoc->Verts[i].flags |= O_HIDDEN; 
			}
			break;
		case SM_TRI: 
			for (i=0; i<pDoc->Tris.GetSize(); i++){
				if ((!(pDoc->Tris[i].Vflags & O_HIDDEN))  && (pDoc->Tris[i].flags & O_SELECTED)) pDoc->Tris[i].Vflags |= O_HIDDEN; 
			}
			break;
		case SM_GROUP: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				for (int k=0; k<pDoc->Objects[i].Groups.GetSize(); k++){
					if ((!(pDoc->Objects[i].Groups[k]->flags & O_HIDDEN)) && (pDoc->Objects[i].Groups[k]->flags & O_SELECTED)) pDoc->Objects[i].Groups[k]->flags |= O_HIDDEN; 
				}
			}
			break;
		case SM_OBJECT: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				if ((!(pDoc->Objects[i].flags & O_HIDDEN)) && (pDoc->Objects[i].flags & O_SELECTED)) pDoc->Objects[i].flags |= O_HIDDEN; 
			}
			break;
		case SM_SKEL: 
			for (i=0; i<pDoc->Skeleton.cnt; i++){
				if ((!(pDoc->Skeleton.hflags[i] & O_HIDDEN)) && (pDoc->Skeleton.tflags[i] & O_SELECTED)) pDoc->Skeleton.hflags[i] |= O_HIDDEN; 
				if ((!(pDoc->Skeleton.tflags[i] & O_HIDDEN)) && (pDoc->Skeleton.hflags[i] & O_SELECTED)) pDoc->Skeleton.tflags[i] |= O_HIDDEN; 
			}
			break;
	}
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
	*/
}

void CChildFrame::OnEditShowall() 
{
/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	int i;
	switch (pDoc->EditMode){
		case SM_VERT: 
			for (i=0; i<pDoc->Verts.GetSize(); i++){ 
				pDoc->Verts[i].flags &=~O_HIDDEN; 
			}
			break;
		case SM_TRI: 
			for (i=0; i<pDoc->Tris.GetSize(); i++){
				pDoc->Tris[i].Vflags &=~O_HIDDEN; 
			}
			break;
		case SM_GROUP: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				for (int k=0; k<pDoc->Objects[i].Groups.GetSize(); k++){
					pDoc->Objects[i].Groups[k]->flags &=~O_HIDDEN; 
				}
			}
			break;
		case SM_OBJECT: 
			for (i=0; i<pDoc->Objects.GetSize(); i++){
				pDoc->Objects[i].flags &=~O_HIDDEN; 
			}
			break;
		case SM_SKEL: 
			for (i=0; i<pDoc->Skeleton.cnt; i++){
				pDoc->Skeleton.hflags[i] &=~O_HIDDEN; 
				pDoc->Skeleton.tflags[i] &=~O_HIDDEN; 
			}
			break;
	}
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
	*/
}

void CChildFrame::OnUpdateOgvSkel(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	pCmdUI->SetCheck(pDoc->EditMode == SM_SKEL);	
}

void CChildFrame::OnUpdateOgvGroup(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	pCmdUI->SetCheck(pDoc->EditMode == SM_GROUP);
}

void CChildFrame::OnUpdateOgvObject(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	pCmdUI->SetCheck(pDoc->EditMode == SM_OBJECT);
}

void CChildFrame::OnUpdateOgvVertex(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	pCmdUI->SetCheck(pDoc->EditMode == SM_VERT);
}
/*
void CChildFrame::OnUpdateXyzXlock(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	pCmdUI->SetCheck(pDoc->Restrict[0] == TRUE);
}

void CChildFrame::OnUpdateXyzYlock(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	pCmdUI->SetCheck(pDoc->Restrict[1] == TRUE);
}

void CChildFrame::OnUpdateXyzZlock(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	pCmdUI->SetCheck(pDoc->Restrict[2] == TRUE);
}

*/


//------------------------------------------------------
// APP ACTIONS

void CChildFrame::OnButtonNone() 
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	theApp.m_AppAction=AA_SELECT;
	//pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
	
}
void CChildFrame::OnUpdateButtonNone(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(theApp.m_AppAction==AA_SELECT);
}


void CChildFrame::OnButtonZoom() 
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	theApp.m_AppAction=AA_ZOOM;
	pDoc->UpdateAllViews(NULL);
}
void CChildFrame::OnUpdateButtonZoom(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(theApp.m_AppAction==AA_ZOOM);
}


void CChildFrame::OnButtonRotate() 
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	theApp.m_AppAction=AA_ROTATE;
	pDoc->UpdateAllViews(NULL);

/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	//pDoc->ViewAct = C_ROTATE;
	theApp.m_AppAction=AA_ROTATE;

	pDoc->RotAngle=0.0f;
	if (pDoc->cur.frameptr != NULL) {
		pDoc->RotHead[0]=.5*(pDoc->cur.frameptr->fbboxmax.v[0]+pDoc->cur.frameptr->fbboxmin.v[0]);
		pDoc->RotHead[1]=.5*(pDoc->cur.frameptr->fbboxmax.v[1]+pDoc->cur.frameptr->fbboxmin.v[1]);
		pDoc->RotHead[2]=pDoc->cur.frameptr->fbboxmax.v[2];
		pDoc->RotTail[0]=pDoc->RotHead[0];
		pDoc->RotTail[1]=pDoc->RotHead[1];
		pDoc->RotTail[2]=pDoc->cur.frameptr->fbboxmin.v[2];
	} else {
		pDoc->RotHead[0]=0;
		pDoc->RotHead[1]=0;
		pDoc->RotHead[2]=20;
		pDoc->RotTail[0]=0;
		pDoc->RotTail[1]=0;
		pDoc->RotTail[2]=-20;
	}
	pDoc->RotHSel=FALSE;
	pDoc->RotTSel=FALSE;
	pDoc->UpdateAllViews(NULL);
	*/
}
void CChildFrame::OnUpdateButtonRotate(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(theApp.m_AppAction==AA_ROTATE);
}



void CChildFrame::OnButtonScale() 
{
	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	theApp.m_AppAction=AA_SCALE;
	pDoc->ScaleVal[0]=1.f; pDoc->ScaleVal[1]=1.f;pDoc->ScaleVal[2]=1.f;
}
void CChildFrame::OnUpdateButtonScale(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(theApp.m_AppAction==AA_SCALE);
}


//---------------------------------------------------------


void CChildFrame::OnDelSel() 
{
/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	if (pDoc->TriAdd) {
		pDoc->TriAdd=FALSE;
		pDoc->UpdateAllViews(NULL);
		return;
	}
	int k;
	BOOL sel;
	int flg;
	int ntri=pDoc->num.triangles;
	int j=0;
	int l;
	for(int i=0; i<ntri; i++){
		if ((!(pDoc->Tris[i].Vflags&O_VHIDDEN)) && (pDoc->Tris[i].Vflags&O_VSELECTED)){
			pDoc->Tris.RemoveAt(j);
			pDoc->num.triangles--;
		} else j++;
	}
	pDoc->Tris.FreeExtra();
	j=0;
	ntri=pDoc->num.vertices;
	for(i=0; i<ntri; i++){
		sel=TRUE;
		for (k=0; k<pDoc->num.triangles; k++){
			for (l=0; l<3; l++) if (pDoc->Tris[k].vindex[l]==i) sel=FALSE;
		}
		if (sel==TRUE){
			pDoc->Verts.RemoveAt(j);
			pDoc->num.vertices--;
		} else {
			for (k=0; k<pDoc->num.triangles; k++){
				for (l=0; l<3; l++) if (pDoc->Tris[k].vindex[l]==i) pDoc->Tris[k].vindex[l]=j;
			}
			pDoc->Base->fv[j].v[0]=pDoc->Base->fv[i].v[0];
			pDoc->Base->fv[j].v[1]=pDoc->Base->fv[i].v[1];
			pDoc->Base->fv[j].v[2]=pDoc->Base->fv[i].v[2];
			pDoc->Base->fv[j].vnormal=pDoc->Base->fv[i].vnormal;
			pDoc->MapGen->fv[j].v[0]=pDoc->MapGen->fv[i].v[0];
			pDoc->MapGen->fv[j].v[1]=pDoc->MapGen->fv[i].v[1];
			pDoc->MapGen->fv[j].v[2]=pDoc->MapGen->fv[i].v[2];
			pDoc->MapGen->fv[j].vnormal=pDoc->MapGen->fv[i].vnormal;
			for (k=0; k<pDoc->Frames.GetSize(); k++){
				pDoc->Frames[k]->fv[j].v[0]=pDoc->Frames[k]->fv[i].v[0];
				pDoc->Frames[k]->fv[j].v[1]=pDoc->Frames[k]->fv[i].v[1];
				pDoc->Frames[k]->fv[j].v[2]=pDoc->Frames[k]->fv[i].v[2];
				pDoc->Frames[k]->fv[j].vnormal=pDoc->Frames[k]->fv[i].vnormal;
			}
			j++;
		}
	}
	pDoc->Verts.FreeExtra();
	FindMinMaxAll(pDoc);
	pDoc->PrimeSort();
	int nobj=pDoc->Objects.GetSize();
	int g=0;
	for (i=0; i<nobj; i++){
		BOOL found=FALSE;
		for (k=0; k<pDoc->Verts.GetSize(); k++) if (pDoc->Verts[k].object==g){
			found=TRUE;
			break;
		}
		if (found) {
			found=FALSE;
			int h=0;
			int ngrp=pDoc->Objects[g].Groups.GetSize();
			for (j=0; j<ngrp; j++){
				for (k=0; k<pDoc->Verts.GetSize(); k++) if ((pDoc->Verts[k].group==h) && (pDoc->Verts[k].object==g)){
					found=TRUE;
					break;
				}
				if ((!found) && (h!=0)){
					delete pDoc->Objects[g].Groups[h];
					pDoc->Objects[g].Groups.RemoveAt(h);
					for (int f=0; f<pDoc->Verts.GetSize(); f++) if ((pDoc->Verts[f].object==g) && (pDoc->Verts[f].group>h)) pDoc->Verts[f].group--;
				} else h++;
			}
			g++;
		} else {
			pDoc->Objects.RemoveAt(g);
			for (int f=0; f<pDoc->Verts.GetSize(); f++) if (pDoc->Verts[f].object>g) pDoc->Verts[f].object--;
		}
	}
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
	*/
}

void CChildFrame::OnFlipSel() 
{
/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	int k=0;
	int flg;
	DWORD swap;
	BOOL sel;
	for(int i=0; i<pDoc->num.triangles; i++){
		if ((!(pDoc->Tris[i].Vflags&O_VHIDDEN)) && (pDoc->Tris[i].Vflags&O_VSELECTED)){
			swap=pDoc->Tris[i].vindex[0];
			pDoc->Tris[i].vindex[0]=pDoc->Tris[i].vindex[1];
			pDoc->Tris[i].vindex[1]=swap;
		}
	}
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
	*/
}

//Remember to add the selection code!
void CChildFrame::OnCloneSel() 
{
/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	int k=0;
	int flg;
	DWORD swap;
	BOOL sel;
	int vmap[VERT_LIMIT];
	int ngrp, nvrt, nobj, ntri;
	nvrt=pDoc->Verts.GetSize();
	pDoc->num.vertices=nvrt;
	nobj=pDoc->Objects.GetSize();
	ntri=pDoc->Tris.GetSize();
	for(int i=0; i<VERT_LIMIT; i++) vmap[i]=0;
	for(i=0; i<pDoc->Objects.GetSize(); i++){
		pDoc->Objects[i].flags &=~O_MODIFY;
		pDoc->Objects[i].dummy = -1;
		for(k=0; k<pDoc->Objects[i].Groups.GetSize(); k++){
			pDoc->Objects[i].Groups[k]->flags &=~O_MODIFY;
			if (k==0) pDoc->Objects[i].Groups[k]->flags |= O_MODIFY;
			pDoc->Objects[i].Groups[k]->dummy = -1;
		}
	}
	for(i=0; i<ntri; i++){
		if ((!(pDoc->Tris[i].Vflags&O_VHIDDEN)) && (pDoc->Tris[i].Vflags&O_VSELECTED)){
			pDoc->Tris[i].Vflags |= O_MODIFY;
			for (k=0; k<3; k++) {
				vmap[pDoc->Tris[i].vindex[k]]=1;
				pDoc->Objects[pDoc->Verts[pDoc->Tris[i].vindex[k]].object].flags |= O_MODIFY;
				pDoc->Objects[pDoc->Verts[pDoc->Tris[i].vindex[k]].object].Groups[pDoc->Verts[pDoc->Tris[i].vindex[k]].group]->flags |= O_MODIFY;
			}
		}
	}
	flg=0;
	for(i=0; i<VERT_LIMIT; i++) if (vmap[i]==1) flg++;
	if (nvrt+flg > VERT_LIMIT){
		AfxMessageBox("You have reached the 2000 vertex limit");
		for(i=0; i<ntri; i++) pDoc->Tris[i].Vflags &= ~O_MODIFY;
		for(i=0; i<pDoc->Objects.GetSize(); i++){
			pDoc->Objects[i].flags &=~O_MODIFY;
			for(k=0; k<pDoc->Objects[i].Groups.GetSize(); k++) pDoc->Objects[i].Groups[k]->flags &=~O_MODIFY;
		}
	} else {
		int g=nobj;
		for(i=0; i<nobj; i++){
			if (pDoc->Objects[i].flags & O_MODIFY){
				pDoc->Objects.SetSize(g+1);
				pDoc->Objects[g].color=pDoc->Objects[i].color;
				pDoc->Objects[g].viscolor=pDoc->Objects[i].viscolor;
				pDoc->Objects[g].flags=pDoc->Objects[i].flags;
				strcpy(pDoc->Objects[g].name, pDoc->Objects[i].name);
				pDoc->Objects[g].dummy=-1;
				pDoc->Objects[g].Groups.RemoveAll();
				pDoc->Objects[i].dummy=g;
				int h=0;
				for (k=0; k<pDoc->Objects[i].Groups.GetSize(); k++){
					if (pDoc->Objects[i].Groups[k]->flags & O_MODIFY){
						Group* tgrp=new Group;
						tgrp->color = pDoc->Objects[i].Groups[k]->color;
						tgrp->flags = pDoc->Objects[i].Groups[k]->flags;
						strcpy(tgrp->name, pDoc->Objects[i].Groups[k]->name);
						tgrp->viscolor = pDoc->Objects[i].Groups[k]->viscolor;
						pDoc->Objects[i].Groups[k]->dummy = h;
						pDoc->Objects[g].Groups.Add(tgrp);
						h++;
					}
				}
				g++;
			}
		}
		for(i=0; i<nvrt; i++){
			if (vmap[i] != 0) {
				vmap[i] = pDoc->num.vertices;
				VertData tvrt;
				tvrt=pDoc->Verts[i];
				if (pDoc->Objects[tvrt.object].dummy != -1){
					if (pDoc->Objects[tvrt.object].Groups[tvrt.group]->dummy != -1) tvrt.group = pDoc->Objects[tvrt.object].Groups[tvrt.group]->dummy;
					tvrt.object = pDoc->Objects[tvrt.object].dummy;
				}
				pDoc->Verts.Add(tvrt);
				pDoc->Base->fv[vmap[i]].v[0]=pDoc->Base->fv[i].v[0];
				pDoc->Base->fv[vmap[i]].v[1]=pDoc->Base->fv[i].v[1];
				pDoc->Base->fv[vmap[i]].v[2]=pDoc->Base->fv[i].v[2];
				pDoc->Base->fv[vmap[i]].vnormal=pDoc->Base->fv[i].vnormal;
				pDoc->MapGen->fv[vmap[i]].v[0]=pDoc->MapGen->fv[i].v[0];
				pDoc->MapGen->fv[vmap[i]].v[1]=pDoc->MapGen->fv[i].v[1];
				pDoc->MapGen->fv[vmap[i]].v[2]=pDoc->MapGen->fv[i].v[2];
				pDoc->MapGen->fv[vmap[i]].vnormal=pDoc->MapGen->fv[i].vnormal;
				for (k=0; k<pDoc->Frames.GetSize(); k++){
					pDoc->Frames[k]->fv[vmap[i]].v[0]=pDoc->Frames[k]->fv[i].v[0];
					pDoc->Frames[k]->fv[vmap[i]].v[1]=pDoc->Frames[k]->fv[i].v[1];
					pDoc->Frames[k]->fv[vmap[i]].v[2]=pDoc->Frames[k]->fv[i].v[2];
					pDoc->Frames[k]->fv[vmap[i]].vnormal=pDoc->Frames[k]->fv[i].vnormal;
				}
				pDoc->num.vertices++;
			}
		}
		for(i=0; i<ntri; i++){
			if (pDoc->Tris[i].Vflags&O_MODIFY){
				pDoc->Tris[i].Vflags &=~O_MODIFY;
				pDoc->Tris.Add(pDoc->Tris[i]);
				for (k=0; k<3; k++) pDoc->Tris[pDoc->num.triangles].vindex[k]=vmap[pDoc->Tris[pDoc->num.triangles].vindex[k]];
				pDoc->num.triangles++;
			}
		}
	}
	for(i=0; i<pDoc->Objects.GetSize(); i++){
		pDoc->Objects[i].flags &=~O_MODIFY;
		for(k=0; k<pDoc->Objects[i].Groups.GetSize(); k++) pDoc->Objects[i].Groups[k]->flags &=~O_MODIFY;
	}
	for(i=0; i<pDoc->Tris.GetSize(); i++) pDoc->Tris[i].Vflags &= ~O_MODIFY;
	pDoc->PrimeSort();
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
	*/
}

void CChildFrame::OnOgvTri() 
{
/*	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT, FALSE);
	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL, FALSE);
	pDoc->EditMode = SM_TRI;
	pDoc->ColorSort();
	pDoc->UpdateAllViews(NULL);
*/
}

void CChildFrame::OnUpdateOgvTri(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	pCmdUI->SetCheck(pDoc->EditMode == SM_TRI);
}

void CChildFrame::OnToggleskelmode() 
{
		
}

void CChildFrame::OnOgvSkel() 
{
//	CMedDLeDoc *pDoc=(CMedDLeDoc *) GetActiveDocument();
//	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_VERTEX, FALSE);
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_TRI, FALSE);
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_GROUP, FALSE);
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_OBJECT, FALSE);
//	Main->m_wndToolBar.GetToolBarCtrl().CheckButton(ID_OGV_SKEL);
//	pDoc->EditMode = SM_SKEL;
//	pDoc->ColorSort();
//	pDoc->UpdateAllViews(NULL);
	
}


