#include "StdAfx.h"
#include "MD3CompleteTranslator.h"
#include "MD3Translator.h"

#include "MBaseObject.h"
#include "MAnimMesh.h"

#include <MSystemManager.h>
#include <params/MKeyParameter.h>

#include "MTextFileStream.h"

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/stat.h>
#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//---------------------------------------------------------------------------------

MMD3CompleteTranslator::MMD3CompleteTranslator()
{
}

MMD3CompleteTranslator::~MMD3CompleteTranslator()
{
}

// Class related
MTranslatorPtr MMD3CompleteTranslator::createNew() const {
   MMD3CompleteTranslator   *NewTranslator;

   NewTranslator = new MMD3CompleteTranslator;

   return NewTranslator;
}

bool MMD3CompleteTranslator::canImportFile(MStr Filename) {
   FILE  *hFile;
   bool  Result = false;
   
   Filename.Replace('/', '\\');
   hFile = fopen(Filename,"rb");

   if (!hFile)
      return false;

   // Split the filename into bits.
   MStr     Drive, Dir, Name, Ext;

   Filename.SplitPath(NULL, NULL, &Name, &Ext);


   if (Name.compareNoCase("animation") == 0 && Ext.compareNoCase(".cfg") == 0)
      Result = true;

  fclose(hFile);

   return Result;
}

bool MMD3CompleteTranslator::importFile(MStr Filename, MScenePtr Scene) {
  Filename.Replace('/', '\\');

  MTextFileReader reader(Filename);

  // return false if we couldn't open the file
  if (!reader.isOpen()) {
    return false;
  }

  MTimeSegmentPtr firstLegsSeg, firstTorsoSeg;
  vector<MTimeSegmentPtr> segmentsAdded;

  // parse the file
  while (!reader.isAtEOF()) {
    MStr str;

    str = reader.readString();

    if (str.GetLength() == 0) {
      continue;
    }

    // check to see if we have a comment
    if (str[0] == '/' && str[1] == '/') {
      reader.readLine();
      continue;
    }

    if (str.compareNoCase("sex") == 0) {
      MStr sex = reader.readString();
    } else if (str.compareNoCase("headoffset") == 0) {
      MStr headOffset = reader.readLine();

    // otherwise we have a frame entry
    } else {
      int start, end, looping;
      MStr fps;

      start = str.ToInt();
      end = start + reader.readString().ToInt() - 1;
      looping = reader.readString().ToInt();
      fps = reader.readString();

      str = reader.readString();

      MTimeSegmentPtr timeSeg = new MTimeSegment();

      timeSeg->setParamByName("fps", fps);
      timeSeg->setRange( Scene->frameToTick(start), Scene->frameToTick(end+1)-1 ); 
      if (str == "//") {
        // parse the comment, other wise try again.
        str = reader.readLine();

        int spaceLoc = -1;

        // find the first whitespace
        for (int loc = 0; str[loc] != '\0'; ++loc) {
          if (isspace(str[loc])) {
            spaceLoc = loc;
            break;
          }
        }

        // if there is whitespace, only get the part before the whitespace.
        if (spaceLoc != -1) {
          // otherwise use only up to the space
          str[spaceLoc] = '\x0';
        }

        if (firstTorsoSeg == NULL && str.findSubstring("TORSO_") != -1) {
          firstTorsoSeg = timeSeg;
        }

        if (firstLegsSeg == NULL && str.findSubstring("LEGS_") != -1) {
          firstLegsSeg = timeSeg;
        }
        timeSeg->setName( str );
      }

      segmentsAdded.push_back(timeSeg);
      Scene->addObject(timeSeg);
    }
  }

  reader.close();
  
  // Import the various sections.
  
  MMD3Translator    MD3Trans;
  MStr              Drive, Path, File, Ext;
  int largestTime = 0;
  MSceneObjectPtr upperObj, headObj, lowerObj;

  
  Filename.SplitPath(&Drive, &Path, NULL, NULL);
  
  MD3Trans.importFile(Drive+Path+"lower.md3", Scene, lowerObj);
  if (Scene->getEndTime() > largestTime) {
    largestTime = Scene->getEndTime();
  }

  // go throguh all the lower objects, and adjust the keys
  // so they do not match.
  // Any key frame in any object that is on or after the first torso
  // segment has to be shifted to the first legs segment start

  // iterate over all the objects in the scene.
  if (firstLegsSeg != NULL && firstTorsoSeg != NULL) {
    MBaseObjectPtr obj;
    MParameterObjectListPtr paramList;
    int shift;

    shift = firstLegsSeg->getStart() - firstTorsoSeg->getStart();

    Scene->getObjectList()->beginIteration();

    while ((obj = Scene->getObjectList()->getNext()) != NULL) {
      MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, obj);

      if (sceneObj == NULL) {
        continue;
      }
      paramList = sceneObj->getParamList();

      for (int index = 0; index < paramList->getNumParams(); ++index) {
        MParameterObjectPtr param = paramList->getParameter(index);
        MKeyParameter *keyParam = AZTEC_CAST(MKeyParameter, param);

        if (keyParam != NULL) {
          MKeyableValuePtr value = keyParam->getKeyableValue();

          if (value != NULL) {
            value->shiftKeys(firstTorsoSeg->getStart(), firstTorsoSeg->getEnd()+1, shift);
          }
        }
      }

      if (sceneObj->getShapeObject() != NULL) {
        // If we have an animated mesh, adjust its vertices.
        MAnimMeshPtr animMesh = AZTEC_CAST(MAnimMesh, sceneObj->getShapeObject()->convertToMesh());

        if (animMesh != NULL) {
          MAnimatedVertex *animVert;

          for (int i = 0; i < animMesh->getNumVerts(); ++i) {
            animVert = animMesh->getAnimVert(i);

            animVert->m_Pos->shiftKeys(firstTorsoSeg->getStart(), firstTorsoSeg->getEnd()+1, shift);
          }
        }
      }
    }
    Scene->getObjectList()->endIteration();
  }

  MD3Trans.importFile(Drive+Path+"upper.md3", Scene, upperObj);
  if (Scene->getEndTime() > largestTime) {
    largestTime = Scene->getEndTime();
  }

  MD3Trans.importFile(Drive+Path+"head.md3", Scene, headObj);
  if (Scene->getEndTime() > largestTime) {
    largestTime = Scene->getEndTime();
  }
  
  Scene->setEndTime(largestTime);
  
  // Go through and parent the various objects
  MTreeObjectNodePtr HeadNode, UpperNode, LowerNode, LowerTorsoTagNode, UpperHeadTagNode;
  
  HeadNode = Scene->getObjectList()->findObject(headObj);
  UpperNode = Scene->getObjectList()->findObject(upperObj);
  LowerNode = Scene->getObjectList()->findObject(lowerObj);
  LowerTorsoTagNode = Scene->getObjectList()->findObjectNode("lowertag_torso_TAG");
  UpperHeadTagNode = Scene->getObjectList()->findObjectNode("uppertag_head_TAG");
  
  MBaseObjectTreePtr Tree;
  
  Tree = Scene->getObjectList();

  if (UpperHeadTagNode != NULL) {
    headObj->setParent(AZTEC_CAST(MSceneObject, UpperHeadTagNode->getObject()));
  }
  if (LowerTorsoTagNode != NULL) {
    upperObj->setParent(AZTEC_CAST(MSceneObject, LowerTorsoTagNode->getObject()));
  }

  // Go through the time segments, and add the required objects
  // to each time segment. If it is a BOTH_ or a LEGS_ segment, then 
  // we add the lowerGroup object. If it is a TORSO_ segment
  // we add the upperGroup object.

  for (int i = 0; i < segmentsAdded.size(); ++i) {
    MTimeSegmentPtr seg = segmentsAdded[i];

    if (seg == NULL) {
      continue;
    }

    if (seg->getName().findSubstring("BOTH_") == 0) {
      seg->addObject(lowerObj);
      seg->addObject(upperObj);
    } else if (seg->getName().findSubstring("LEGS_") == 0) {
      seg->addObject(lowerObj);
    } else if (seg->getName().findSubstring("TORSO_") == 0) {
      seg->addObject(upperObj);
    }
  }
  
  return true;
}

bool MMD3CompleteTranslator::exportFile(MStr Filename, MScenePtr scene) {
  MStr basePath;

  {
    MStr drive, path, file, ext;
    Filename.SplitPath(&drive, &path, &file, &ext);

    basePath = drive + path;
  }

  MMD3Translator md3Trans;

  MBaseObjectPtr obj;
  vector<MTreeObjectNodePtr> exclude;
  MSceneObjectPtr headObj, lowerObj, upperObj;
  MTreeObjectNodePtr headNode, lowerNode, upperNode;

  // find the objects which are the upper, lower and head
  scene->getObjectList()->beginIteration();
  while ((obj = scene->getObjectList()->getNext()) != NULL) {
    MTreeObjectNodePtr node = scene->getObjectList()->getCurrentNode();
    MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, obj);

    if (sceneObj == NULL) {
      continue;
    }

    MStr q3ObjName;
    if (sceneObj->getParamByName("q3obj", q3ObjName)) {
      if (q3ObjName.compareNoCase("upper") == 0) {
        upperObj = sceneObj;
        upperNode = node;
      }
      if (q3ObjName.compareNoCase("lower") == 0) {
        lowerObj = sceneObj;
        lowerNode = node;
      }
      if (q3ObjName.compareNoCase("head") == 0) {
        headObj = sceneObj;
        headNode = node;
      }
    }

  }
  scene->getObjectList()->endIteration();

  getSystemManager()->logOutput("Writing the lower md3 file...");
  exclude.clear();
  exclude.push_back(upperNode);
  md3Trans.exportObject(basePath + "testlower.md3", scene, lowerObj, exclude);
  getSystemManager()->logOutput("Done writing the lower md3 file...");

  getSystemManager()->logOutput("Writing the upper md3 file...");
  exclude.clear();
  exclude.push_back(headNode);
  md3Trans.exportObject(basePath + "testupper.md3", scene, upperObj, exclude);
  getSystemManager()->logOutput("Done writing the head md3 file...");

  getSystemManager()->logOutput("Writing the head md3 file...");
  exclude.clear();
  md3Trans.exportObject(basePath + "testhead.md3", scene, headObj, exclude);
  getSystemManager()->logOutput("Done writing the head md3 file...");

  return false;
}


