
#ifndef LBMTRANSLATOR_H
#define LBMTRANSLATOR_H

#include <translator/MImageTranslator.h>


using namespace Aztec;



class MLBMTranslator : public MImageTranslator {
protected:

public:
   MLBMTranslator();
   virtual ~MLBMTranslator();

   // Class related
   virtual MStr getClassName() {return MStr("MLBMTranslator");};
   virtual MStr getParentClassName() {return MStr("MImageTranslator");};
   virtual MTranslatorPtr createNew() const;

   std::string getFilter() { return "*.LBM"; }
   std::string getFilterDescription() { return "Deluxe Paint files"; }
   virtual bool canImport() {return true;};
   virtual bool canExport() {return false;};
   virtual bool canImportFile(MStr Filename);

   virtual bool importFile(MStr Filename, MImagePtr Image);
   virtual bool exportFile(MStr Filename, MImagePtr Image);
};


#endif
