#ifndef PRIMTRI_H
#define PRIMTRI_H

#include "MBaseObject.h"
#include "MSceneObject.h"
#include "MEditableMesh.h"

//------------------
//  MPrimitiveTetra
//------------------
class MPrimitiveTri : public Aztec::MShapeObject {
protected:
  Aztec::MVector3 m_V0, m_V1, m_V2;
  Aztec::MMeshPtr m_LastMesh;

public:
  // Construction/Destruction
  MPrimitiveTri();
  virtual ~MPrimitiveTri();

  // Class related
  virtual MStr getClassName() {return MStr("MPrimitiveTri");};
  virtual MStr getParentClassName() {return MStr("MBaseObject");};
  virtual Aztec::MBaseObjectPtr createNew();

  // Animation Keying
  void updateKey(int Time, DWORD Channel, bool CreateKey);

  virtual Aztec::MMeshPtr convertToMesh();
};

#endif 