#ifndef StdPrimitives_Plane_Header
#define StdPrimitives_Plane_Header

#include <mesh/MMeshCreator.h>

#include <params/MFloatParameter.h>
#include <params/MIntParameter.h>

class Plane : public Aztec::MMeshCreator {
protected:
  Aztec::MFloatParameterPtr wParam, hParam;
  Aztec::MIntParameterPtr divwParam, divhParam;
  float width, height;
  int divw, divh;
  Aztec::MMeshPtr lastMesh;
  
public:
  // Construction/Destruction
  Plane();
  virtual ~Plane();
  
  // MBaseObject methods
  MStr getClassName() {return MStr("Plane");};
  Aztec::MBaseObjectPtr createNew();
  bool doUpdateObject();
  
protected:
  Aztec::MMeshPtr convertToMesh();
};




#endif


