// ParticleSinkEditDlg.cpp: implementation of the CParticleSinkEditDlg class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include <stdlib.h>

#include "dialogs/ParticleSinkEditDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CParticleSinkEditDlg::CParticleSinkEditDlg() :
	CDomainEditDlg(),
	kill_inside(false)
{

}

CParticleSinkEditDlg::~CParticleSinkEditDlg()
{

}

void CParticleSinkEditDlg::setEntriesFromParams(int startIndex, particleParamType &entries)
{
	int i = 0;
	// Pull the sink specific parameters
	kill_inside = (entries[i++] == 0.0f ? false : true);

	CDomainEditDlg::setEntriesFromParams(i, entries);

	// Put the member values into the edit controls
	setEditLayout(m_Domain);
}

void CParticleSinkEditDlg::getParamsFromEntries(particleParamType &params)
{
	// Get the sink specific parameters
	params.push_back((IsDlgButtonChecked(IDC_PARTICLE_KILL_INSIDE_CHECK) == BST_CHECKED ? 1.0f : 0.0f));

	// Get the generic domain parameters
	CDomainEditDlg::getParamsFromEntries(params);
}

LRESULT CParticleSinkEditDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	CDomainEditDlg::OnInitDialog(uMsg, wParam, lParam, bHandled);

	::ShowWindow(GetDlgItem(IDC_SOURCE_EXTRA_GROUP), SW_SHOW);
	SetDlgItemText(IDC_SOURCE_EXTRA_GROUP, "Sink Unique");
	::ShowWindow(GetDlgItem(IDC_PARTICLE_KILL_INSIDE_CHECK), SW_SHOW);

	return 0;
}

void CParticleSinkEditDlg::setEditLayout(PDomainEnum domain)
{
	CDomainEditDlg::setEditLayout(domain);

	LPARAM state = (kill_inside ? BST_CHECKED : BST_UNCHECKED);
	CheckDlgButton(IDC_PARTICLE_KILL_INSIDE_CHECK, state);
}
