// ParticleActionEditDlg.cpp: implementation of the CParticleActionEditDlg class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include <assert.h>
#include "resource.h"

#include "dialogs/ParticleActionEditDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CParticleActionEditDlg::CParticleActionEditDlg(MPrimitiveParticle::actionType::actionEnum actionType, bool edit_existing) :
	colorDlg(1, 1, 1, 1), m_ActionType(actionType), m_EditExisting(edit_existing)
{
	paramBox = NULL;
	currentParamWnd = NULL;
}

CParticleActionEditDlg::~CParticleActionEditDlg()
{

}

void CParticleActionEditDlg::setParams(std::vector< float > &entries)
{
	OutputDebugString("Set particle entries\n");
	m_params = entries;
}

void CParticleActionEditDlg::getParams(std::vector< float > &params)
{
	OutputDebugString("Get particle entries\n");
	params = m_params;
}

LRESULT CParticleActionEditDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	int index;
	// Add the list of attribute/action choices to the combo list
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Avoid");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::avoid);
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Bounce");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::bounce);
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Color");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::color);
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Damping");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Explosion");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Follow");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Gravitate");
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Gravity");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::gravity);
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Jet");
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"KillOld");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::killOld);
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"MatchVelocity");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Move");
	// SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::move);
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"OrbitLine");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"OrbitPoint");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Random Accel");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Random Displace");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Random Velocity");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Restore");
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Sink");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::sink);
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Sink Velocity");
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Size");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::size);
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Source");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::source);
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"SpeedLimit");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Starting Age");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Target Color");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Target Size");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Target Velocity");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Time Step");
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Velocity");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::velocity);
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"VelocityDomain");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::velocityDomain);
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Vertex");
	// index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"VertexB");
	index = SendDlgItemMessage(IDC_ACTION_COMBO, CB_ADDSTRING, 0, (LPARAM)"Vortex");
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SETITEMDATA, index, (LPARAM)MPrimitiveParticle::actionType::vortex);

	// Find out the area that edit fields get placed
	paramBox = GetDlgItem(IDC_PARAMETERS);
	if (paramBox != NULL) {
		::GetClientRect(paramBox, &paramRect);
		paramRect.left += 1;
		paramRect.right -= 2;
		paramRect.top += 14;
		paramRect.bottom -= 2;
		// ::OffsetRect(&paramRect, 2, 8);
		// ::InflateRect(&paramRect, -4, -16);
	} else {
		paramRect.left   = 3;
		paramRect.top    = 8;
		paramRect.right  = 80;
		paramRect.bottom = 100;
	}

	// Create the dialog boxes that are placed within the parameter area.
	colorDlg.Create(paramBox);
	domainDlg.Create(paramBox);
	sourceDlg.Create(paramBox);
	bounceDlg.Create(paramBox);
	velocityDlg.Create(paramBox);
	sinkDlg.Create(paramBox);
	vortexDlg.Create(paramBox);
	killoldDlg.Create(paramBox);

	selectEditLayout(m_ActionType);

	if ((currentParamWnd != NULL) && !m_params.empty()) {
		currentParamWnd->setEntriesFromParams(0, m_params);
	}

	// Start things off with the appropriate entry selected
	SendDlgItemMessage(IDC_ACTION_COMBO, CB_SELECTSTRING, -1, (LPARAM)selectComboEntry(m_ActionType));

	// Enable/Disable the combo box based on whether or not we are allowing the user
	// to change the type of action.  Normally it will only be changed if the user
	// is creating a new action.
	if (m_EditExisting) {
		::EnableWindow(GetDlgItem(IDC_ACTION_COMBO), FALSE);
	} else {
		// We are allowing changing of the editing fields
		::EnableWindow(GetDlgItem(IDC_ACTION_COMBO), TRUE);
	}

	return 0;
}

char * CParticleActionEditDlg::selectComboEntry(MPrimitiveParticle::actionType::actionEnum actionEntry)
{
	char *entryStr = NULL;

	switch (actionEntry) {
	case MPrimitiveParticle::actionType::color:
		entryStr = "Color";
		break;
	case MPrimitiveParticle::actionType::colorDomain:
		entryStr = "Color";
		break;
	case MPrimitiveParticle::actionType::size:
		entryStr = "Size";
		break;
	case MPrimitiveParticle::actionType::sizeDomain:
		entryStr = "Size";
		break;
	case MPrimitiveParticle::actionType::startingAge:
		entryStr = "Starting Age";
		break;
	case MPrimitiveParticle::actionType::timeStep:
		entryStr = "Time Step";
		break;
	case MPrimitiveParticle::actionType::velocity:
		entryStr = "Velocity";
		break;
	case MPrimitiveParticle::actionType::vertexB:
		entryStr = "VertexB";
		break;
	case MPrimitiveParticle::actionType::vertexBTracks:
		entryStr = "VertexB Tracks";
		break;
	case MPrimitiveParticle::actionType::avoid:
		entryStr = "Avoid";
		break;
	case MPrimitiveParticle::actionType::bounce:
		entryStr = "Bounce";
		break;
	case MPrimitiveParticle::actionType::copyVertexB:
		entryStr = "Copy VertexB";
		break;
	case MPrimitiveParticle::actionType::damping:
		entryStr = "Damping";
		break;
	case MPrimitiveParticle::actionType::explosion:
		entryStr = "Explosion";
		break;
	case MPrimitiveParticle::actionType::follow:
		entryStr = "Follow";
		break;
	case MPrimitiveParticle::actionType::gravitate:
		entryStr = "Gravitate";
		break;
	case MPrimitiveParticle::actionType::gravity:
		entryStr = "Gravity";
		break;
	case MPrimitiveParticle::actionType::jet:
		entryStr = "Jet";
		break;
	case MPrimitiveParticle::actionType::killOld:
		entryStr = "Kill Old";
		break;
	case MPrimitiveParticle::actionType::matchVelocity:
		entryStr = "Match Velocity";
		break;
	case MPrimitiveParticle::actionType::move:
		entryStr = "Move";
		break;
	case MPrimitiveParticle::actionType::orbit:
		entryStr = "Orbit";
		break;
	case MPrimitiveParticle::actionType::randomAccel:
		entryStr = "Random Accel";
		break;
	case MPrimitiveParticle::actionType::randomDisplace:
		entryStr = "Random Displace";
		break;
	case MPrimitiveParticle::actionType::randomVelocity:
		entryStr = "Random Velocity";
		break;
	case MPrimitiveParticle::actionType::restore:
		entryStr = "Restore";
		break;
	case MPrimitiveParticle::actionType::sink:
		entryStr = "Sink";
		break;
	case MPrimitiveParticle::actionType::sinkVelocity:
		entryStr = "Sink Velocity";
		break;
	case MPrimitiveParticle::actionType::source:
		entryStr = "Source";
		break;
	case MPrimitiveParticle::actionType::speedLimit:
		entryStr = "Speed Limit";
		break;
	case MPrimitiveParticle::actionType::targetColor:
		entryStr = "Target Color";
		break;
	case MPrimitiveParticle::actionType::targetSize:
		entryStr = "Target Size";
		break;
	case MPrimitiveParticle::actionType::targetVelocity:
		entryStr = "Target Velocity";
		break;
	case MPrimitiveParticle::actionType::vertex:
		entryStr = "Vertex";
		break;
	case MPrimitiveParticle::actionType::vortex:
		entryStr = "Vortex";
		break;
	default:
		entryStr = NULL;
	}

	return entryStr;
}

CParticleActionDlgBase *CParticleActionEditDlg::selectEditDlg(MPrimitiveParticle::actionType::actionEnum actionEntry)
{
	CParticleActionDlgBase *editDlg = NULL;

	switch (actionEntry) {
	case MPrimitiveParticle::actionType::color:
		editDlg = &colorDlg;
		break;
	case MPrimitiveParticle::actionType::colorDomain:
		editDlg = &colorDlg;
		break;
	case MPrimitiveParticle::actionType::size:
		editDlg = &domainDlg;
		break;
	case MPrimitiveParticle::actionType::sizeDomain:
		editDlg = &domainDlg;
		break;
	case MPrimitiveParticle::actionType::startingAge:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::timeStep:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::velocity:
		editDlg = &velocityDlg;
		velocityDlg.setBoxTitle("Velocity Direction");
		break;
	case MPrimitiveParticle::actionType::velocityDomain:
		editDlg = &domainDlg;
		break;
	case MPrimitiveParticle::actionType::vertexB:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::vertexBTracks:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::avoid:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::bounce:
		editDlg = &bounceDlg;
		break;
	case MPrimitiveParticle::actionType::copyVertexB:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::damping:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::explosion:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::follow:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::gravitate:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::gravity:
		editDlg = &velocityDlg;
		velocityDlg.setBoxTitle("Gravity Direction");
		break;
	case MPrimitiveParticle::actionType::jet:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::killOld:
		editDlg = &killoldDlg;
		break;
	case MPrimitiveParticle::actionType::matchVelocity:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::move:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::orbit:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::randomAccel:
		editDlg = &domainDlg;
		break;
	case MPrimitiveParticle::actionType::randomDisplace:
		editDlg = &domainDlg;
		break;
	case MPrimitiveParticle::actionType::randomVelocity:
		editDlg = &domainDlg;
		break;
	case MPrimitiveParticle::actionType::restore:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::sink:
		editDlg = &sinkDlg;
		break;
	case MPrimitiveParticle::actionType::sinkVelocity:
		editDlg = &domainDlg;
		break;
	case MPrimitiveParticle::actionType::source:
		editDlg = &sourceDlg;
		break;
	case MPrimitiveParticle::actionType::speedLimit:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::targetColor:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::targetSize:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::targetVelocity:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::vertex:
		editDlg = NULL;
		break;
	case MPrimitiveParticle::actionType::vortex:
		editDlg = &vortexDlg;
		break;
	default:
		editDlg = NULL;
	}

	return editDlg;
}

void CParticleActionEditDlg::selectEditLayout(MPrimitiveParticle::actionType::actionEnum actionEntry)
{
	if (currentParamWnd != NULL) {
		currentParamWnd->ShowWindow(SW_HIDE);
	}

	CParticleActionDlgBase *newParamWnd = selectEditDlg(actionEntry);

	// If we are changing editing controls, then clear out the area where they go.
	if (newParamWnd != currentParamWnd) {
		InvalidateRect(NULL, TRUE);
	}

	if (newParamWnd != NULL) {
		newParamWnd->MoveWindow(&paramRect);
		newParamWnd->ShowWindow(SW_SHOW);
	}

	currentParamWnd = newParamWnd;
}

LRESULT CParticleActionEditDlg::OnActionComboChange(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	if (currentParamWnd != NULL) {
		currentParamWnd->ShowWindow(SW_HIDE);
	}

	CParticleActionDlgBase *newParamWnd = NULL;

	int curSel = SendDlgItemMessage(IDC_ACTION_COMBO, CB_GETCURSEL);

	// Determine which action by casting the combo box entry to an actionEnum.  Note that
	// this only works if the entries in the 
	MPrimitiveParticle::actionType::actionEnum actionEntry =
		(MPrimitiveParticle::actionType::actionEnum)SendDlgItemMessage(IDC_ACTION_COMBO, CB_GETITEMDATA, curSel, (LPARAM)0);
	if (actionEntry == CB_ERR) {
		actionEntry = MPrimitiveParticle::actionType::color;
		OutputDebugString("Bad entry selection in CParticleActionEditDlg\n");
	}

	m_ActionType = actionEntry;
	selectEditLayout(actionEntry);

	return 0;
}

LRESULT CParticleActionEditDlg::OnOk(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	// Pull values from the edit controls and put them into the result members
	// 	m_ActionType and m_params.
	if (currentParamWnd == NULL) {
		// No edit dialog - how did this happen?  Can't return values...
		// assert(false);
		EndDialog(1);
		return 0;
	}

	m_params.clear();
	currentParamWnd->getParamsFromEntries(m_params);

	EndDialog(0);

	return 0;
}

LRESULT CParticleActionEditDlg::OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	EndDialog(-1);

	return 0;
}
