// AztecGUIPlugin.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "AztecGUIMParameterPlugin.h"
#include "MSystemManager.h"

#include "ParticlesPlugin.h"
#include "ParticleShapePlugin.h"
#include "ParticleScript.h"

extern "C" {
#define XP_PC
#include "jsapi.h"
}

extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
    if (dwReason == DLL_PROCESS_ATTACH) {
        _Module.Init(NULL, hInstance);
        DisableThreadLibraryCalls(hInstance);
    } else if (dwReason == DLL_PROCESS_DETACH) {
        _Module.Term();
	}
	
    return TRUE;
}

CComModule _Module;

Aztec::MSystemManager *primSysMan = NULL;

PARTICLESPLUGIN_API
int ModQueryVersion(long *Dest)
{
   memcpy(Dest, MODEL_API_VERSION, 4);
   return 1;
}

PARTICLESPLUGIN_API
int ModQueryDesc(char *Dest)
{
   strcpy(Dest, "Contains the particle system plugin and GUI extensions.");
   return 1;
}

PARTICLESPLUGIN_API
int ModQueryCount()
{
   return 1;
}

PARTICLESPLUGIN_API
int ModRegister(Aztec::MSystemManager *SysMan, int IDNo)
{
   // Cache the system manager for later use
   primSysMan = SysMan;

   // Register the primitive types we know about
   switch (IDNo)
   {
   case 0:
      return SysMan->getPluginManager()->registerPrimitive( new MPrimitiveParticle , "Particle");
      break;
   }

   return 0;
}

PARTICLESPLUGIN_API
int ModScripting(JSContext *cx, JSObject *global)
{
	Aztec::addParticleClass(cx);

	return 0;
}

PARTICLESPLUGIN_API
AztecGUI::MParameterPluginPtr getGUIPlugin(int index)
{
	switch (index) {
	case 0:
		return new ParticleShapePlugin();
	default:
		return NULL;
	}
}

PARTICLESPLUGIN_API
int getGUIPluginCount() {
	return 1;
}
