#ifndef PARTICLEACTIONARRAYPARAM_H
#define PARTICLEACTIONARRAYPARAM_H

#include "PrimParticle.h"
#include "params/MIntParameter.h"
#include <params/MAggregateParameter.h>

namespace Aztec {

// Provide a representation of a specific action.  TBD: break into more specific
// chunks rather than using a generic array of floats.
class FloatArrayParam : public virtual MArrayParameterAdapter,
	public MParameterObjectImpl {
public:
	FloatArrayParam(MPrimitiveParticle *particle, int index);
	~FloatArrayParam();
	MBaseObject* getOwner() const;
	void setOwner(Aztec::MBaseObject *newOwner);
	int getElementCount();
	int addElement();
	void removeElement(int index);
	void resize(int size);
	MParameterObjectPtr getElement(int index);
	bool getElement(int index, float &value);
	bool setElement(int index, float value);
	int getElementType() const;
	int getDataMeaning() const;
	MParameterObjectPtr createCopy();

protected:
	MPrimitiveParticle *mParticle;
	int mActionIndex;	// Which action in the particle system
};

class ParticleActionValue : public MIntParameter {
public:
	ParticleActionValue(MPrimitiveParticle *particle, int index);

    // MIntParameter methods
    int getValue();

    // MParameterObject methods
    int getDataType() const;
    int getDataMeaning() const;
    MStr getShortName() const;
    MStr getLongName() const;
    MStr getFriendlyName() const;
    MBaseObject* getOwner() const;
    void setOwner(MBaseObject *newOwner);
    bool isInputParameter();
    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);
    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);
    bool createKeyAt(long time);
    bool setFromParameter(MParameterObjectPtr src);
    bool isConnectable();
    bool isConnected();
    bool setInputParameter(const MParameterObjectPtr &input);
    MParameterObjectPtr getInputParameter();
    MParameterObjectPtr createCopy();

private:
	MPrimitiveParticle *mParticle;
	int mActionIndex;	// Which action in the particle system
};


// Provide a representation of a specific action.  TBD: break into more specific
// chunks rather than using a generic array of floats.
class ParticleActionElement : public MAggregateParameter, public MParameterObjectImpl {
public:
	ParticleActionElement(MPrimitiveParticle *particle, int index);
	~ParticleActionElement();

	// MAggregateParameter methods
	int getMemberCount();
	MParameterObjectPtr getMember(int index);
	MStr getMemberName(int index);
	int getMemberIndex(const MStr &name);

	// MParameterObject methods (not satisfied by MParameterObjectImpl)
    int getDataType() const;
	int getDataMeaning() const;
    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);
    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);

	MParameterObjectPtr createCopy();

private:
	MPrimitiveParticle *mParticle;
	int mActionIndex;
};


class ParticleActionParam : public virtual MArrayParameterAdapter,
	public MParameterObjectImpl {
public:
	ParticleActionParam(MPrimitiveParticle *particle);
	~ParticleActionParam();
	MBaseObject* getOwner() const;
	void setOwner(Aztec::MBaseObject *newOwner);
	bool isInputParameter();
	int getElementCount();
	int addElement();
	void removeElement(int index);
	void resize(int size);
	MParameterObjectPtr getElement(int index);
	bool getElement(int index, MStr &value);
	bool getElement(int index, Aztec::MVector3 &value);
	bool setElement(int index, const MStr &value);
	bool setElement(int index, const Aztec::MVector3 &value);
	int getElementType() const;

	int getDataMeaning() const;
	bool createKeyAt(long time);
	MParameterObjectPtr createCopy();

protected:
	MPrimitiveParticle *mParticle;
};

}
#endif // PARTICLEACTIONARRAYPARAM_H
