#include <gui/MApplication.h>

#include <gui/MWindow.h>
#include <gui/MLabel.h>
#include <gui/MBorderLayout.h>
#include <gui/MButton.h>

#include <scripting/MScriptInterp.h>

#include <misc/ResourceManager.h>
using namespace Aztec;




class HelloWorld : public Aztec::MApp {
public:

  class Callback : public CScriptCallbacks {
  public:
    int puts(const char *str) {
      if (str != NULL) {
        OutputDebugString(str);
      }
      return 1;
    }

  
  };
  Callback callback;

  bool initApp() {
    // set up our resource paths so we can load scripts
    Aztec::ResourceManager::addResourcePath(getApplicationPath());
    Aztec::ResourceManager::addResourcePath(getApplicationPath() + "/../../common2");

    // now execute our gui script.
    MScriptInterpreter *interp = MScriptInterpreter::getInstance();

    interp->putCallbacks(&callback);
    interp->ExecuteScript("load('GUIExamples/GUI_Examples_launcher.js');");

    return true;
  }

  void cleanup() {

    MApp::cleanup();
  }

};


AZTEC_USE_APP(HelloWorld)