// BaseViewWnd.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "BaseViewWnd.h"

#include "resource.h"
#include "MDLMsgs.h"
#include "MDLGlobs.h"
#include "DlgGlobs.h"
#include "KeyFuncView.h"

#include <MCamera.h>
#include <misc/MSceneHelper.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const int CAMERA_MENU_BASE = 16000;
static const int borderWidth = 2;

//---------------------------------------------------------------------------
//  MBaseViewWndList
//---------------------------------------------------------------------------
MBaseViewWndPtr SetCurrentView(MBaseViewWndPtr NewView) {
  if (g_CurView == NewView) {
    return NewView;
  }
  
  MBaseViewWndPtr OldView;
  
  OldView = g_CurView;
  g_CurView = NewView;
  
  if (OldView != NULL && ::IsWindow(OldView->m_hWnd)) {
    OldView->Invalidate();
    OldView->UpdateWindow();
  }
  
  if (g_CurView != NULL && ::IsWindow(OldView->m_hWnd)) {
    g_CurView->Invalidate();
    g_CurView->UpdateWindow();
  }
  
  return OldView;
}

MBaseViewWndPtr setCurrentViewForControl(CWnd *control) {
  MBaseViewWnd *view = NULL;
  while (control != NULL) {
    MBaseViewWnd *tempView = AZTEC_CAST(MBaseViewWnd, control);
    if (tempView != NULL) {
      view = tempView;
    }
    control = control->GetParent();
  }
  
  if (view != NULL) {
    return ::SetCurrentView(view);
  }
  return NULL;
}

MBaseViewWndList::MBaseViewWndList() {
  m_List = new MBaseObjectList;
}

MBaseViewWndList::~MBaseViewWndList() {
  m_List = NULL;
}

void MBaseViewWndList::AddView(MBaseViewWndPtr View) {
  if (View == NULL) {
    return;
  }
  
  m_List->addHead(View);
}

void MBaseViewWndList::DeleteView(MBaseViewWndPtr View) {
  MListObjectNodePtr Node;
  Node = m_List->findNode(View);
  
  if (Node != NULL) {
    MBaseViewWndPtr View;
    
    View = AZTEC_CAST(MBaseViewWnd, Node->getObject());
    
    // Are we deleting the current view?
    if (g_CurView == View) {
      g_CurView = NULL;
    }
    
    if (View != NULL) {
      View->DestroyWindow();
    }
    
    m_List->removeNode(Node);
  }
  g_CurView = AZTEC_CAST(MBaseViewWnd, m_List->getHead());
}

void MBaseViewWndList::DeleteAllViews() {
  MBaseViewWndPtr View;
  m_List->beginIteration();
  while (( View = AZTEC_CAST(MBaseViewWnd, m_List->getNext() )) != NULL ) {
    if (::IsWindow(View->m_hWnd)) {
      View->DestroyWindow();
    }
  }
  m_List->endIteration();
  m_List->removeAllNodes();
}

void MBaseViewWndList::DrawAllViews() {
  MBaseViewWndPtr View;

  // update the entire scene if necessary
  g_Scene->updateObject(NULL);

  m_List->beginIteration();
  while (( View = AZTEC_CAST(MBaseViewWnd, m_List->getNext() )) != NULL ) {
    View->DrawView();
  }
  m_List->endIteration();
}

MBaseViewWndPtr MBaseViewWndList::FindViewOfType(const MStr &Type) {
  MListObjectNodePtr Node;
  
  Node = m_List->findObjectWithClass(Type);
  if (Node != NULL) {
    return AZTEC_CAST(MBaseViewWnd, Node->getObject());
  }
  
  return NULL;
}

MBaseViewWndPtr MBaseViewWndList::FindViewFromHWND(HWND hWnd) {
  MBaseObjectPtr Obj;
  MBaseViewWndPtr View;
  
  m_List->beginIteration();
  while (( Obj = m_List->getNext() ) != NULL ) {
    View = AZTEC_CAST(MBaseViewWnd, Obj);
    
    if (View == NULL) {
      continue;
    }
    
    if (View->m_hWnd == hWnd) {
      return View;
    }
  }
  m_List->endIteration();
  
  return NULL;
}


//---------------------------------------------------------------------------
// MBaseViewWnd
//---------------------------------------------------------------------------
MBaseViewWnd::MBaseViewWnd() {
  menuBar = NULL;
}

MBaseViewWnd::~MBaseViewWnd() {
  if (menuBar != NULL) {
    delete menuBar;
  }
}

MBaseObjectPtr MBaseViewWnd::createNew() {
  return NULL;
}

void MBaseViewWnd::ViewCreate() {
  CMenu* pSysMenu = GetSystemMenu(FALSE);
  if (pSysMenu != NULL) {
    pSysMenu->AppendMenu(MF_SEPARATOR);
    pSysMenu->AppendMenu(MF_STRING, ID_SYSMENU_CHILDTOMAINWINDOW, "Child to Main Window");
  }
  
  // Set the icons for the window
  {
    HICON    hIcon;
    
    hIcon = (HICON)::LoadImage(AfxGetApp()->m_hInstance, (LPCTSTR)IDR_MAINFRAME, IMAGE_ICON, 16, 16, 0);
    int   Err = ::GetLastError();
    SetIcon(hIcon, FALSE);
    
    hIcon = (HICON)::LoadImage(AfxGetApp()->m_hInstance, (LPCTSTR)IDR_MAINFRAME, IMAGE_ICON, 32, 32, 0);
    SetIcon(hIcon, TRUE);
  }

  // add in a menu bar
  if (menuBar == NULL) {
    RECT clientRect;
    GetClientRect(&clientRect);
    menuBar = new MMenuBar;
    menuBar->Create(NULL, 
                    "MenuBar", 
                    WS_CHILD | WS_CLIPSIBLINGS, 
                    CRect(clientRect.left,clientRect.top,clientRect.right,24), 
                    this, 
                    0);

    menuBar->addMenu("Views", new MMenuBar::PopupMenu(IDR_COMMON_VIEWMENU));
    menuBar->SetWindowPos(NULL, clientRect.left, clientRect.top, clientRect.right, menuBar->getMenuHeight(), SWP_NOZORDER | SWP_NOMOVE);
    clientRect.top += menuBar->getMenuHeight();
    
    menuBar->ShowWindow(SW_SHOW);
  }
}

void MBaseViewWnd::DrawView() {
  g_Scene->updateObject(NULL);

  // Draw the border of the view.
  {
    HDC paintDC = ::GetDC(m_hWnd);
    RECT rect;
    ::GetClientRect(m_hWnd, &rect);

    if (isCurrentView()) {
      drawSelectedBorder(paintDC, rect, borderWidth);
    } else {
      drawSelectedBorder(paintDC, rect, borderWidth, 0x808080);
    }

    ::ReleaseDC(m_hWnd, paintDC);
  }


}

bool MBaseViewWnd::isCurrentView() {
  return (g_CurView == this);
}

void MBaseViewWnd::setAsCurrentView() {
  SetCurrentView(this);
}

void MBaseViewWnd::drawSelectedBorder(HDC dc, RECT &rect, int width, int colour) {
  RECT drawRect;
  HBRUSH hBrush;

  hBrush = ::CreateSolidBrush(colour);

  drawRect.left = rect.left;
  drawRect.right = rect.right;
  drawRect.top = rect.top;
  drawRect.bottom = drawRect.top + width;
  ::FillRect(dc, &drawRect, hBrush);

  drawRect.left = rect.left;
  drawRect.right = rect.right;
  drawRect.bottom = rect.bottom;
  drawRect.top = drawRect.bottom - width;
  ::FillRect(dc, &drawRect, hBrush);

  drawRect.left = rect.left;
  drawRect.right = drawRect.left + width;
  drawRect.top = rect.top;
  drawRect.bottom = rect.bottom;
  ::FillRect(dc, &drawRect, hBrush);

  drawRect.right = rect.right;
  drawRect.left = drawRect.right - width;
  drawRect.top = rect.top;
  drawRect.bottom = rect.bottom;
  ::FillRect(dc, &drawRect, hBrush);

  ::DeleteObject(hBrush);
}


BEGIN_MESSAGE_MAP(MBaseViewWnd, CWnd)
//{{AFX_MSG_MAP(MBaseViewWnd)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

LRESULT MBaseViewWnd::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam) {
  LRESULT result = CWnd::DefWindowProc(message, wParam, lParam);

  if (message == WM_LBUTTONDOWN ||
      message == WM_MBUTTONDOWN ||
      message == WM_RBUTTONDOWN) {
    MShiftState newState = m_ShiftState;
    if (message == WM_LBUTTONDOWN) newState.m_Left = true;
    if (message == WM_MBUTTONDOWN) newState.m_Mid = true;
    if (message == WM_RBUTTONDOWN) newState.m_Right = true;
    int x = (short int)LOWORD(lParam);
    int y = (short int)HIWORD(lParam);

    doMouseDown(x,y,newState);
  } else if (message == WM_LBUTTONUP ||
            message == WM_MBUTTONUP ||
            message == WM_RBUTTONUP) {
    MShiftState newState = m_ShiftState;
    if (message == WM_LBUTTONUP) newState.m_Left = false;
    if (message == WM_MBUTTONUP) newState.m_Mid = false;
    if (message == WM_RBUTTONUP) newState.m_Right = false;
    int x = (short int)LOWORD(lParam);
    int y = (short int)HIWORD(lParam);

    doMouseUp(x,y,newState);
  } else if (message == WM_MOUSEMOVE) {
    int x = (short int)LOWORD(lParam);
    int y = (short int)HIWORD(lParam);

    doMouseMove(x,y);
  } else if (message == WM_SIZE) {
    onSize();
  } else if (message == WM_COMMAND) {
    if (lParam == 0) {
      int menuResult = HandlePopupCommand(LOWORD(wParam));
      bool update = false;
      
      // The command was handled, but the view was changed, so we must return.
      if (menuResult != -1) {
      
        if (menuResult == 1) {
          update = true;
        } else {
          update = false;
        }
      
        if (update) {
          Invalidate();
          UpdateWindow();
        }
      }
      if (menuResult != 0) {
        result = 1;
      }
    }
  }

  return result;
}

BOOL MBaseViewWnd::PreTranslateMessage(MSG* pMsg) {


  if (pMsg->message == WM_SYSCOMMAND) {
    if (pMsg->wParam == ID_SYSMENU_CHILDTOMAINWINDOW) {
      // Modify the window style here.
      //         ModifyStyle(WS_CHILD, WS_OVERLAPPEDWINDOW, SWP_NOCOPYBITS);
      //         ModifyStyleEx(WS_EX_TOPMOST | WS_EX_TOOLWINDOW, WS_EX_OVERLAPPEDWINDOW, SWP_NOCOPYBITS);
      //         SetParent(g_MainDlg);
      //         ModifyStyle(WS_CHILD, WS_OVERLAPPEDWINDOW, SWP_NOCOPYBITS);
      
      /*         if (::GetParent(m_hWnd) == g_MainDlg->m_hWnd)
      {
      ::SetParent(m_hWnd, NULL);
      }
      else
      {
      ::SetParent(m_hWnd, g_MainDlg->m_hWnd);
    }*/
    }
  }
  
  return CWnd::PreTranslateMessage(pMsg);
}

int MBaseViewWnd::HandlePopupCommand(DWORD Cmd) {
  switch (Cmd) {
  case ID_VIEWS_MAKECOPY:
    KViewportMakeCopy();
    return 1;
  case ID_VIEWS_PERSPECTIVE:
    KViewportPerspective();
    return -1;
  case ID_VIEWS_TOP:
    KViewportTop();
    return -1;
  case ID_VIEWS_BOTTOM:
    KViewportBottom();
    return -1;
  case ID_VIEWS_FRONT:
    KViewportFront();
    return -1;
  case ID_VIEWS_BACK:
    KViewportBack();
    return -1;
  case ID_VIEWS_LEFT:
    KViewportLeft();
    return -1;
  case ID_VIEWS_RIGHT:
    KViewportRight();
    return -1;
  case ID_VIEWS_SCENEOUTLINE:
    KViewportSceneOutline();
    return -1;
  case ID_VIEWS_UVEDIT:
    KViewportUVEdit();
    return -1;
  case ID_VIEWS_SEGMENTEDITOR:
    KViewportSegmentEditor();
    return -1;
  case ID_VIEWS_GRAPHVIEW:
    KViewportGraphView();
    return -1;
  case ID_VIEWS_PARAMETERVIEW:
    KViewportParameterView();
    return -1;
  case ID_VIEWS_IMAGEVIEWER:
    KViewportImageView();
    return -1;
  case ID_VIEWS_RENDERVIEW:
    KViewportRenderView();
    return -1;
  }

  // I can't imagine us having more than 50 camers
  if (Cmd >= CAMERA_MENU_BASE && Cmd < CAMERA_MENU_BASE + 50) {
    MSceneHelper<MCamera>::SceneShapeVector cameras;
    MSceneHelper<MCamera>::findObjectsOfType(g_Scene, cameras);

    KViewportPerspective(cameras[Cmd - CAMERA_MENU_BASE].first);

    return -1;
  }
  
  return 0;
}

int MBaseViewWnd::InitPopupMenu(CMenu *PopupMenu) {
  if (!PopupMenu) {
    return 0;
  }
  
  CMenu    CommonMenu;
  CMenu    *ViewMenuPopup;
  int cameraMenuIndex = -1;
  
  CommonMenu.LoadMenu(IDR_COMMON_VIEWMENU);
  ViewMenuPopup = CommonMenu.GetSubMenu(0);

  for (cameraMenuIndex = ViewMenuPopup->GetMenuItemCount() - 1; cameraMenuIndex >= 0; cameraMenuIndex--) {
    CString item;
    ViewMenuPopup->GetMenuString(cameraMenuIndex, item, MF_BYPOSITION);
    if (item.CompareNoCase("camera") == 0) {
      break;
    }
  }

  if (cameraMenuIndex > -1) {
    CMenu *cameraMenu = ViewMenuPopup->GetSubMenu(cameraMenuIndex);
    if (cameraMenu != NULL) {
      // now remove any other menu items there
      while (cameraMenu->GetMenuItemCount() > 0) {
        cameraMenu->DeleteMenu(0, MF_BYPOSITION);
      }

      // find all the cameras in our scene
      MSceneHelper<MCamera>::SceneShapeVector cameras;

      MSceneHelper<MCamera>::findObjectsOfType(g_Scene, cameras);

      // put all the cameras we know of into a menu
      if (cameras.size() == 0) {
        cameraMenu->AppendMenu(MF_STRING | MF_GRAYED, 0, "No Cameras in Scene");
      } else {
        for (int i = 0; i < cameras.size(); ++i) {
          cameraMenu->AppendMenu(MF_STRING, CAMERA_MENU_BASE + i, cameras[i].first->getName().c_str());
        }
      }
    }
  }
  PopupMenu->AppendMenu(MF_SEPARATOR);
  PopupMenu->AppendMenu(MF_POPUP | MF_STRING, (DWORD)ViewMenuPopup->m_hMenu, "View");
  
  return 1;
}


/////////////////////////////////////////////////////////////////////////////
// MBaseViewWnd message handlers

void MBaseViewWnd::onMouseUp(int X, int Y, MShiftState Shift) {
}

void MBaseViewWnd::onMouseDown(int X, int Y, MShiftState Shift) {
}

void MBaseViewWnd::onMouseMove(int X, int Y, MShiftState Shift) {
}

void MBaseViewWnd::onSize() {
  // we use the win32 get client rect here because we do not want to get our adjusted client rectangle.
  CRect clientRect;
  ::GetClientRect(m_hWnd, &clientRect);
  if (menuBar != NULL) {
    if (menuBar->m_hWnd != NULL) {
      int menuHeight = menuBar->getMenuHeight();
      menuBar->SetWindowPos(NULL,
                             clientRect.left, clientRect.top,
                             clientRect.Width(), menuHeight,
                             SWP_NOZORDER);

      // we get the menu height again because the height of the menu may have 
      // changed during the layour process.
      clientRect.top += menuBar->getMenuHeight();
    }
  }
}

void MBaseViewWnd::doMouseDown(int x, int y, MShiftState newState) {
  RECT clientRect;
  GetClientRect(&clientRect);
  x -= clientRect.left;
  y -= clientRect.top;

  setAsCurrentView();
  SetCapture();
  
  if (!m_ShiftState.m_Left && !m_ShiftState.m_Mid && !m_ShiftState.m_Right) {
    m_DownX = x;
    m_DownY = y;
  }

  // only do a popup menu if we have just the right mouse button down
  if (newState.m_Left == false && newState.m_Mid == false && newState.m_Right == true) {

    // Check to see if we have clicked on the text in the top left.
    if (x >= m_PopupRect.left && x <= m_PopupRect.right &&
      y >= m_PopupRect.top && y <= m_PopupRect.bottom) {
      // Make a new popup menu
      CPoint   Pnt(x,y);
      
      ClientToScreen(&Pnt);
      
      ViewPopupMenu(Pnt.x, Pnt.y);
      
      return;
    }
  }

  RECT     WindowRect;
  int      ToolX, ToolY;

  ::GetClientRect(m_hWnd, &WindowRect);
  ToolX = x - WindowRect.right + 18;
  ToolY = y;

  // Check to see if we have hit the button in the top right of the view

  // Check to see if we have hit inside the top right tool buttons
  if (ToolX > 0 && ToolX < 18 && ToolY < 18) {
    // have we hit the maxmize button
    KViewportFullScreen();
  } else {
    m_ShiftState = newState;
    m_ShiftState.SetFromKeyState();
    onMouseDown(x, y, m_ShiftState);
  }
}

void MBaseViewWnd::doMouseUp(int x, int y, MShiftState newState) {
  RECT clientRect;
  GetClientRect(&clientRect);
  x -= clientRect.left;
  y -= clientRect.top;

  m_ShiftState = newState;
  m_ShiftState.SetFromKeyState();
  
  onMouseUp(x, y, m_ShiftState);
  
  if (!m_ShiftState.m_Left && !m_ShiftState.m_Mid && !m_ShiftState.m_Right)
  {
    ReleaseCapture();
  }
}

void MBaseViewWnd::doMouseMove(int x, int y) {
  RECT clientRect;
  GetClientRect(&clientRect);
  x -= clientRect.left;
  y -= clientRect.top;

  m_ShiftState.SetFromKeyState();
  onMouseMove(x, y, m_ShiftState);
}

MToolTypePtr MBaseViewWnd::getSelectTool() {
  return NULL;
}

bool MBaseViewWnd::isAnythingSelected() {
  return false;
}

void MBaseViewWnd::handleToolResult(int result) {
  if (result == TOOLRESULT_DRAWALL) {
    // update the channel bar and all the view ports if
    // necessary.
    g_MainDlg->PostMessage(MM_UPDATECHANNELBAR); 
    g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  } else if (result == TOOLRESULT_DRAWCURRENT) {
    DrawView();
  }
}

MShiftState MBaseViewWnd::getShiftState() {
  return m_ShiftState;
}

MMenuBar* MBaseViewWnd::getMenuBar() {
  return menuBar;
}

void MBaseViewWnd::GetClientRect(LPRECT rect) {
  getClientRect(rect);
}

void MBaseViewWnd::GetClientRect(CRect *rect) {
  getClientRect(rect);
}


void MBaseViewWnd::getClientRect(LPRECT rect) {
  CRect clientRect;
  ::GetClientRect(m_hWnd, &clientRect);

  clientRect.left += borderWidth;
  clientRect.top += borderWidth;
  clientRect.right -= borderWidth;
  clientRect.bottom -= borderWidth;

  // now take off the menu bar size.
  if (menuBar != NULL) {
    if (menuBar->m_hWnd != NULL) {
      int menuHeight = menuBar->getMenuHeight();
      menuBar->SetWindowPos(NULL,
                             clientRect.left, clientRect.top,
                             clientRect.Width(), menuHeight,
                             SWP_NOZORDER);

      // we get the menu height again because the height of the menu may have 
      // changed during the layour process.
      clientRect.top += menuBar->getMenuHeight();
    }
  }

  *rect = clientRect;
}



