#include <AztecMainPCH.h>

#include "resource.h"

#include "MenuItem.h"
#include "Keyboard.h"
#include "MdlConst.h"

#include "DlgGlobs.h"   // Global dialog variables.
#include "MdlGlobs.h"
#include "MdlMsgs.h"

#include "KeyFuncGeneral.h"
#include "KeyFuncMain.h"

#include "MEditableMesh.h"
#include "MClusterModifier.h"
#include "MMeshShape.h"
#include "MUIManager.h"
#include "MLight.h"
#include <MCamera.h>

#include "MBone.h"

#include "SceneViewWnd.h"
#include "GraphViewWnd.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


static void updateAllViewports() {
  if (g_MainDlg != NULL) {
    g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  }
}
static void updateChannelBar() {
  if (g_MainDlg != NULL) {
    g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  }
}

int finishTool() {
  MToolTypePtr curTool = g_ToolMan.GetTool();

  // if we have no tool, then default to the select tool.
  if (curTool == NULL) {
    g_ToolMan.setTool(g_CurView->getSelectTool());
    return 1;
  }

  // otherwise, finish up the tool.
  if (curTool->finish()) {
    g_ToolMan.PopTool();
    updateAllViewports();
    updateChannelBar();
  }

  return 1;
}

int cancelTool() {
  MToolTypePtr curTool = g_ToolMan.GetTool();

  // if we have no tool, then default to the select tool.
  if (curTool == NULL) {
    g_ToolMan.setTool(g_CurView->getSelectTool());
    return 1;
  }

  // otherwise, cancel the tool.
  if (curTool->cancel()) {
    g_ToolMan.PopTool();
    updateAllViewports();
    updateChannelBar();
  }

  return 1;
}

void InitGeneralActionList(MActionListType *AL) {
  g_SysMan->logOutput("Initialising General Action List");
  
  // General
  AL->Add("KModeObject", "Object Mode","General",KModeObject);
  AL->Add("KModePoint", "Point Mode","General",KModePoint);
  AL->Add("KModeFace", "Face Mode","General",KModeFace);
  AL->Add("KModeEdge", "Edge Mode","General",KModeEdge);
  AL->Add("KModeCycle", "Cycle Selection Mode","General",KModeCycle);
  AL->Add("separateAxisModeToggle", "Toggle Separate Axis Mode", "General", KSeparateAxisToggle);
  
  AL->Add("KObjectDuplicateSelected", "Duplicate Selected", "General", KObjectDuplicateSelected, g_MainDlg, ID_EDIT_DUPLICATE);
  AL->Add("KObjectDeleteSelected", "Delete Selected", "General", KObjectDeleteSelected, g_MainDlg, ID_EDIT_DELETE_SELECTED);
  AL->Add("KObjectCentrePivot", "Centre Pivot Point", "General", KObjectCentrePivot, g_MainDlg, ID_EDIT_CENTREPIVOT);
  
  AL->Add("KPrimitiveCreateTransform", "Create Empty Transform", "General", KPrimitiveCreateTransform, g_MainDlg, ID_PRIMITIVES_CREATETRANSFORM);
  AL->Add("KPrimitiveCreateLight", "Create Light", "General", KPrimitiveCreateLight, g_MainDlg, ID_PRIMITIVES_CREATELIGHT);
  AL->Add("KPrimitiveCreateCamera", "Create Camera", "General", KPrimitiveCreateCamera, g_MainDlg, ID_PRIMITIVES_CREATECAMERA);
  AL->Add("KPrimitiveCreateMaterial", "Create Material", "General", KPrimitiveCreateMaterial, g_MainDlg, ID_MATERIALS_CREATEMATERIAL);
  AL->Add("KPrimitiveCreateBone", "Create Bone", "General", KPrimitiveCreateBone, g_MainDlg, ID_PRIMITIVES_CREATEBONE);
  
  AL->Add("KDeformCreateCluster", "Create Cluster", "Deform", KDeformCreateCluster, g_MainDlg, ID_DEFORM_CREATECLUSTER);
  AL->Add("KDeformAttachBones", "Attach Bones", "Deform", KDeformAttachBones, g_MainDlg, ID_DEFORM_ATTACHBONES);
  AL->Add("KDeformAssignClusterWeight", "Assign Cluster Weight", "Deform", KDeformAssignClusterWeight, g_MainDlg, ID_DEFORM_ASSIGNCLUSTERWEIGHT);
  
  
  AL->Add("KSelectParent", "Select Parent", "General", KSelectParent);
  AL->Add("KSelectChild", "Select Child", "General", KSelectChild);
  AL->Add("KSelectPrevSibling", "Select Previous Sibling", "General", KSelectPrevSibling);
  AL->Add("KSelectNextSibling", "Select Next Sibling", "General", KSelectNextSibling);
  
  AL->Add("KParentSelection", "Parent Selection", "General", KParentSelection, g_MainDlg, ID_EDIT_PARENT);
  AL->Add("KUnparentSelection", "Unparent Selection", "General", KUnparentSelection, g_MainDlg, ID_EDIT_UNPARENT);
  
  AL->Add("KAssignMaterialToSelection", "Assign Current Material To Selection", "General", KAssignMaterialToSelection);
  
  AL->Add("finishTool", "Finish the current tool's action", "Tools", finishTool);
  AL->Add("cancelTool", "Cancel the current tool's action", "Tools", cancelTool);

}

  
//----------------------------------------------------------------------------------------
#define GetDlgButton(D,R)     ((CButton*)D.GetDlgItem(R))


int KModeupdateObjectModes() {
  // change all objects currently in component mode back into object mode
  MBaseObjectPtr Obj;
  MMeshPtr mesh;
  
  g_Scene->getObjectList()->beginIteration();
  
  while ((Obj = g_Scene->getObjectList()->getNext()) != NULL) {
    if (!Obj->isFlagged(OBJECTFLAG_SELECTED)) {
      continue;
    }

    MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, Obj);
    if (sceneObj == NULL) {
      continue;
    }

    MComponentisedObjectPtr compObj = sceneObj->getComponentObject();
    
    if (compObj != NULL) {
      compObj->setComponentMode(MUIManager::getComponentMode());
    }
  }
  g_Scene->getObjectList()->endIteration();
  
  return 1;
}

int KModeObject() {
  MUIManager::setComponentMode(MComponentisedObject::OBJECT_TYPE);
  KModeupdateObjectModes();
  updateAllViewports();
  updateChannelBar();
  return 1;
}

int KModePoint() {
  MUIManager::setComponentMode(MComponentisedObject::POINT_TYPE);
  KModeupdateObjectModes();
  updateAllViewports();
  updateChannelBar();
 	return 1;
}

int KModeFace() {
  MUIManager::setComponentMode(MComponentisedObject::FACET_TYPE);
  KModeupdateObjectModes();
  updateAllViewports();
  updateChannelBar();
 	return 1;
}

int KModeEdge() {
  MUIManager::setComponentMode(MComponentisedObject::EDGE_TYPE);
  KModeupdateObjectModes();
  updateAllViewports();
  updateChannelBar();
 	return 1;
}



int KModeCycle() {
  if (MUIManager::getComponentMode() == MComponentisedObject::OBJECT_TYPE) {
    KModePoint();
  } else if (MUIManager::getComponentMode() == MComponentisedObject::POINT_TYPE) {
    KModeFace();
  } else if (MUIManager::getComponentMode() == MComponentisedObject::FACET_TYPE) {
    KModeEdge();
  } else if (MUIManager::getComponentMode() == MComponentisedObject::EDGE_TYPE) {
    KModeObject();
  }
  
  return 1;
}

int KSeparateAxisToggle() {
  MUIManager::setSeparateAxisMode( !MUIManager::getSeparateAxisMode() );
  return 1;
}

int KObjectDeleteSelected() {
  MBaseObjectListPtr ObjList;
  MBaseObjectPtr Obj;
  bool DeleteChildren;
  
  // TODO: this should be made so that different view behaviours are in
  // separate functions, and the keyboard handling should be redirected 
  // based on what view is active. This shouldn't be the rsponsiblity of 
  // each function!!!
  COpenGLWnd *glView = AZTEC_CAST(COpenGLWnd, g_CurView);
  CSceneViewWnd *outlineView = AZTEC_CAST(CSceneViewWnd, g_CurView);

  if (glView != NULL || outlineView != NULL) {
    if (MUIManager::getComponentMode() == MComponentisedObject::OBJECT_TYPE) {
    
      ObjList = g_Scene->getSelectedObjectList();
    
      MParameterObjectPtr Var = g_ProgSet.GetToolParameter("KObjectDeleteSelected", "DeleteChildren");
      if (Var != NULL) {
        int val;
        if (Var->getValueInteger(val)) {
          DeleteChildren = (val != 0);
        }
        Var = NULL;
      }
    
      ObjList->beginIteration();
      while ((Obj = ObjList->getNext()) != NULL) {
        g_Scene->deleteObject(AZTEC_CAST(MNamedObject, Obj), DeleteChildren);
      }
      ObjList->endIteration();
    
      updateAllViewports();
      updateChannelBar();

    } else {
      // Delete some vertices
    
      // go through the selection and see what objects can have vertices deleted
      MEditableMeshPtr MeshObj;
      MSceneObjectPtr SceneObj;
    
      ObjList = g_Scene->getSelectedObjectList();
    
      ObjList->beginIteration();
   
      while ((Obj = ObjList->getNext()) != NULL) {
        SceneObj = AZTEC_CAST(MSceneObject, Obj);
      
        if (SceneObj == NULL || SceneObj->getShapeObject() == NULL) continue;
      
        MeshObj = AZTEC_CAST(MEditableMesh, SceneObj->getShapeObject()->convertToMesh());
    
        if (MeshObj == NULL) continue;
    
        if (MeshObj->isInComponentMode(MComponentisedObject::POINT_TYPE)) {
          MeshObj->deleteVertexFlag(VERTEX_SELECTED);
        } else if (MeshObj->isInComponentMode(MComponentisedObject::FACET_TYPE)) {
          MeshObj->deleteTriangleFlag(TRIANGLE_SELECTED);
        } else {
          g_SysMan->logOutput("Warning: Nothing Deleted. Cannot Delete Component");
        }
      
      }
      ObjList->endIteration();

      updateAllViewports();
      updateChannelBar();
    
    }
  } else {
    // if we are in a graph view, we should delete the selected keys.
    CGraphViewWnd *graphView = AZTEC_CAST(CGraphViewWnd, g_CurView);

    if (graphView != NULL) {
      graphView->deleteSelectedKeys();

      updateAllViewports();
      updateChannelBar();
    }

  }
  return 1;
}

int KObjectDuplicateSelected() {
	{
		MBaseObjectPtr Obj;
		
		g_Scene->getObjectList()->beginIteration();
		while ((Obj = g_Scene->getObjectList()->getNext()) != NULL) {
			MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, Obj);
			if (sceneObj != NULL) {
				MComponentisedObjectPtr compObj = sceneObj->getComponentObject();
				if (compObj != NULL) {
					compObj->setComponentMode(MComponentisedObject::OBJECT_TYPE);
				}
			}
		}
		g_Scene->getObjectList()->endIteration();
	}
	
	MBaseObjectPtr SelBaseObj, NewBaseObj;
	MNamedObjectPtr NewParent, SelObj, NewObj;
	MTreeObjectNodePtr NewObjNode, SelObjNode, ParentNode, NewParentNode;
	MBaseObjectListPtr      NewSelList = new MBaseObjectList();
	
	bool DupParentGroup = true;
	
  MParameterObjectPtr Var = g_ProgSet.GetToolParameter("KObjectDuplicateSelected", "Dup_ParentGroup");
  if (Var != NULL) {
    int val;
    if (Var->getValueInteger(val)) {
      DupParentGroup = (val != 0);
    }
    Var = NULL;
  }
	
	
	NewParent = NULL;
	NewParentNode = NULL;
	
	g_Scene->getSelectedObjectList()->beginIteration();
	
	while ((SelBaseObj = g_Scene->getSelectedObjectList()->getNext()) != NULL) {
		SelObj = AZTEC_CAST(MNamedObject, SelBaseObj);
		
		// we can't duplicate unnamed objects, so don't try.
		if (SelObj == NULL) {
			continue;
		}
		
		NewBaseObj = SelObj->createNew();
		
		NewObj = AZTEC_CAST(MNamedObject, NewBaseObj);
		
		{
			SelObjNode = g_Scene->getObjectList()->findObject(SelObj);
			ParentNode = SelObjNode->getParent();
			
			if (DupParentGroup) {
				if (ParentNode != NULL) {
					NewParent = AZTEC_CAST(MNamedObject, ParentNode->getObject()->createNew());
					NewParentNode = g_Scene->addObject(NewParent, ParentNode->getParent());
				}
			} else {
				NewParentNode = ParentNode;
			}
		}
		
		NewObj->setName(SelObj->getName());
		NewObjNode = g_Scene->addObject(NewObj, NewParentNode);
		NewSelList->addHead(NewObj);
	}
	g_Scene->getSelectedObjectList()->endIteration();
	
	g_Scene->selectNone();
	
	NewSelList->beginIteration();
	while ((SelBaseObj = NewSelList->getNext()) != NULL) {
		g_Scene->selectObject(SelBaseObj);
	}
	NewSelList->endIteration();
	
	KModeObject();
	
	updateAllViewports();
	updateChannelBar();
	
	return 1;
}

int KObjectCentrePivot() {
  MBaseObjectPtr SelObj;
  MSceneObjectPtr SceneObj;
  
  g_Scene->getSelectedObjectList()->beginIteration();
  
  while ((SelObj = g_Scene->getSelectedObjectList()->getNext()) != NULL) {
    SceneObj = AZTEC_CAST(MSceneObject, SelObj);

    if (SceneObj == NULL) continue;

    SceneObj->centrePivot();
  }
  g_Scene->getSelectedObjectList()->endIteration();
  
  updateAllViewports();
  updateChannelBar();
  
  return 1;
}


int KPrimitiveCreateTransform() {
  MSceneObjectPtr EmptyObject;
  MTreeObjectNodePtr TransNode;
  
  EmptyObject = new MSceneObject;
  EmptyObject->setName("XForm");
  /*   Trans->getTranslateVector(0).set(0,0,0);
  Trans->updateKey(0,TRANSFORM_CHAN_TRANSLATE, g_SysMan->GetSettings()->m_Animate);*/
  
  TransNode = g_Scene->addObject(EmptyObject);
  
  // Go through the current Selected objects, and set the parent to the new transform node
  {
    MBaseObjectPtr Obj;
    MTreeObjectNodePtr ObjNode;
    
    g_Scene->getSelectedObjectList()->beginIteration();
    while ((Obj = g_Scene->getSelectedObjectList()->getNext()) != NULL) {
      MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, Obj);

      if (sceneObj == NULL) continue;

      EmptyObject->setParent(sceneObj->getParent());
      sceneObj->setParent(EmptyObject);
    }
    g_Scene->getSelectedObjectList()->endIteration();
  }
  
  g_Scene->selectNone();
  g_Scene->selectObject(EmptyObject);
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KPrimitiveCreateLight()
{
  MSceneObjectPtr sceneObj;
  MLightPtr lightShape;
  MTreeObjectNodePtr ParentNode;
  
  lightShape = new MLight;
  lightShape->setName("lightShape");
  
  lightShape->setParamByName("Col", "1 1 1");

  sceneObj = new MSceneObject(lightShape);
  sceneObj->setName("light");
  ParentNode = g_Scene->addObject(sceneObj);
  
  KEditSelectNone();
  g_Scene->selectObject(sceneObj);
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KPrimitiveCreateCamera() {
  MSceneObjectPtr sceneObj;
  MCameraPtr cameraShape;
  MTreeObjectNodePtr ParentNode;
  
  cameraShape = new MCamera;
  cameraShape->setName("cameraShape");
  
  cameraShape->setParamByName("fov", "90");

  sceneObj = new MSceneObject(cameraShape);
  sceneObj->setName("camera");
  ParentNode = g_Scene->addObject(sceneObj);
  
  KEditSelectNone();
  g_Scene->selectObject(sceneObj);
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 0;
}


int KPrimitiveCreateMaterial() {
  MMaterialPtr Material;
  
  Material = new MMaterial;
  Material->setName("Material");
  
  g_Scene->addObject(Material);
  
  KModeObject();
  g_Scene->selectNone();
  g_Scene->selectObject(Material);
  
  Material = NULL;
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KDeformCreateCluster()
{
  MBaseObjectPtr SelObj;
  MSceneObjectPtr SelSceneObj;
  MMeshPtr SelMesh;
  MVector3       Center;
  
  SelObj = g_Scene->getSelectedObjectList()->getHead();
  
  if (SelObj == NULL)
    return 0;
  
  SelSceneObj = AZTEC_CAST(MSceneObject, SelObj);
  if (SelSceneObj == NULL)
    return 0;
  
  SelMesh = AZTEC_CAST(MMesh, SelSceneObj->getShapeObject()->convertToMesh());
  //   SelMesh = AZTEC_CAST(MMesh, SelObj);
  
  if (SelMesh == NULL)
    return 0;
  
  // Go through the vertices and mark those selected with the change flag
  {
    int            n, NumVerts;
    
    NumVerts = 0;
    
    for (n=0; n < SelMesh->getNumVerts(); n++) {
      if (SelMesh->isVertexFlagged(n, VERTEX_SELECTED)) {
        SelMesh->setVertexFlag(n, VERTEX_FLAGFORCHANGE);
        Center += SelMesh->getVertexPosition(n);
        NumVerts++;
      } else {
        SelMesh->unsetVertexFlag(n, VERTEX_FLAGFORCHANGE);
      }
    }
    
    Center /= (float)NumVerts;
  }
  
  
  // Create the Cluster control object.
  
  MSceneObjectPtr ControlObject;
  MClusterModifierPtr ClusterMod;
  
  ControlObject = new MSceneObject;
  ControlObject->setName("ClusterControl");

  g_Scene->addObject(ControlObject);
  ControlObject->getTransformObject()->setTranslateVector(Center);
  ControlObject->getTransformObject()->updateKey(g_Scene->getTime());
  
  ClusterMod = new MClusterModifier;
  ClusterMod->setName("ClusterModifier");
  g_Scene->addObject(ClusterMod);
  
  ClusterMod->setControllingObject(ControlObject);

  SelSceneObj->insertModifier(ClusterMod);

  KModeObject();
  
  g_Scene->updateObject(ControlObject);
  
  g_Scene->selectNone();
  g_Scene->selectObject(ControlObject);
  
  ClusterMod = NULL;
  ControlObject = NULL;
  SelMesh = NULL;
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KDeformAssignClusterWeight()
{
	float ClusterWeight = 1.0f;
	MBaseObjectPtr SelObj;
	MClusterModifierPtr ClusterMod;
	
  MParameterObjectPtr Var = g_ProgSet.GetToolParameter("KDeformAssignClusterWeight", "Assign_ClusterWeight");
  if (Var != NULL) {
    float val;
    if (Var->getValueFloat(val)) {
      ClusterWeight = val;
    }
    Var = NULL;
  }
	
	if (MUIManager::getComponentMode() != MComponentisedObject::POINT_TYPE) {
		g_SysMan->logOutput("Error: KDeformAssignClusterWeight - Must be in Point Component Mode");
		return 0;
	}
	
	SelObj = g_Scene->getSelectedObjectList()->getHead();
	
	if (SelObj == NULL) {
		g_SysMan->logOutput("Error: KDeformAssignClusterWeight - No Objects Selected");
		return 0;
	}
	
	ClusterMod = AZTEC_CAST(MClusterModifier, SelObj);
	
	if (ClusterMod == NULL) {
		g_SysMan->logOutput("Error: KDeformAssignClusterWeight - Selection is not a Cluster Modifier");
		return 0;
	}
	
	
	if (!ClusterMod->hasComponentsSelected(MComponentisedObject::POINT_TYPE)) {
		g_SysMan->logOutput("Error: KDeformAssignClusterWeight - No Vertices Selected");
		return 0;
	}
	
	for (int n = 0; n < ClusterMod->getNumPoints(); n++) {
    if (ClusterMod->isPointSelected(n)) {
      ClusterMod->setPointWeight(n, ClusterWeight);
		}
	}
	
	g_Scene->updateObject(NULL);
	
	::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
	::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
	
	return 1;
}



int KDeformAttachBones_CreateClusters(MTreeObjectNodePtr TreeNode, MTreeObjectNodePtr DeformObjNode) {
  if (TreeNode == NULL || DeformObjNode == NULL) {
    return 0;
  }
  
  // Walk the child tree and recurse the function.
  {
    MTreeObjectNodePtr OldNode;
    
    OldNode = TreeNode;
    TreeNode = TreeNode->getFirstChild();
    while (TreeNode != NULL) {
      KDeformAttachBones_CreateClusters(TreeNode, DeformObjNode);
      TreeNode = TreeNode->getNextSibling();
    }
    
    TreeNode = OldNode;
  }
  
  MBoneObjectPtr CurBoneShape, ParentBoneShape;
  MSceneObjectPtr DeformObj, parentBoneObj, curBoneObj;
  MTreeObjectNodePtr parentBoneObjNode;
  MMeshShapePtr deformMeshShape;
  MMeshPtr DeformMesh;
  
  parentBoneObjNode = TreeNode->getParent();
  DeformObj = AZTEC_CAST(MSceneObject, DeformObjNode->getObject());
  curBoneObj = AZTEC_CAST(MSceneObject, TreeNode->getObject());
  CurBoneShape = AZTEC_CAST(MBoneObject, curBoneObj->getShapeObject());
  if (parentBoneObjNode != NULL) {
    parentBoneObj = AZTEC_CAST(MSceneObject, parentBoneObjNode->getObject());
  } else {
    parentBoneObj = NULL;
  }
  
  if (DeformObj != NULL) {
    deformMeshShape = AZTEC_CAST(MMeshShape, DeformObj->getShapeObject());
    if (deformMeshShape != NULL) {
      DeformMesh = deformMeshShape->getMeshObject();
    }
  } else {
    DeformMesh = NULL;
  }
  
  if (CurBoneShape != NULL && DeformObj != NULL && DeformMesh != NULL && parentBoneObjNode != NULL) {
    
    MVector3    StartPos, EndPos, BoneVec, ControlPivot;
    
    // StartPos will be the parent bone's world coords from its local(0,0,0);
    StartPos.set(0,0,0);
    StartPos = g_Scene->objectToWorldSpace(parentBoneObjNode, StartPos);
    
    // EndPos will be the current bone's world coords from its local(0,0,0);
    EndPos.set(0,0,0);
    EndPos = g_Scene->objectToWorldSpace(TreeNode, EndPos);
    
    
    // covnert both the start and end pos vectors into the object space of hte mesh
    ControlPivot = g_Scene->worldToObjectSpace(TreeNode, StartPos);
    StartPos = g_Scene->worldToObjectSpace(DeformObjNode, StartPos);
    EndPos = g_Scene->worldToObjectSpace(DeformObjNode, EndPos);
    
    //      ControlPivot = CurBone->getTransformObject()->getTranslateVector(g_Scene->getTime());
    ControlPivot.set(0,0,0);
    ControlPivot = g_Scene->objectToWorldSpace(DeformObjNode, ControlPivot);
    ControlPivot = g_Scene->worldToObjectSpace(parentBoneObjNode, ControlPivot);
    ControlPivot *= -1;
    
    
    BoneVec = EndPos - StartPos;
    BoneVec.normalize();
    
    
    // Go through the vertices, and mark those vertices that lie between the two planes
    {
      int n;
      for (n = 0; n < DeformMesh->getNumVerts(); n++)
      {
        MVector3 Vert;
        float       StartDot, EndDot;
        MVector3    StartVec, EndVec;
        
        Vert = DeformMesh->getVertexPosition(n);
        
        StartVec = Vert - StartPos;
        EndVec = Vert - EndPos;
        StartVec.normalize();
        EndVec.normalize();
        StartDot = StartVec * BoneVec;
        EndDot = EndVec * BoneVec;
        
        // if we are inside the plane, then startdot will be positive and end dot will be negative
        if (StartDot > 0 && EndDot < 0) {
          DeformMesh->setVertexFlag(n, VERTEX_FLAGFORCHANGE);
        } else {
          DeformMesh->unsetVertexFlag(n, VERTEX_FLAGFORCHANGE);
        }
      }
    }
    
    
    // Create the control object, and the cluster modifier
    {
      MSceneObjectPtr ControlObject;
      MClusterModifierPtr ClusterMod;
      
      ControlObject = parentBoneObj;
      
      ClusterMod = new MClusterModifier;
      ClusterMod->setName("ClusterModifier");
      ClusterMod->setControllingObject(ControlObject);
      g_Scene->addObject(ClusterMod);
      
      if (deformMeshShape != NULL) {
        DeformObj->insertModifier(ClusterMod);
      }
      
      g_Scene->updateObject(ControlObject);
      
      ClusterMod = NULL;
    }
    
   }
   
   DeformMesh = NULL;
   
   return 1;
}

MBoneObjectPtr getBoneObject(MBaseObjectPtr obj) {
  // Cast it into a bone object, if successful, we have a bone
  MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, obj);

  if (sceneObj != NULL) {
    MBoneObjectPtr bone = AZTEC_CAST(MBoneObject, sceneObj->getShapeObject());

    return bone;
  }
  return NULL;
}

int KDeformAttachBones()
{
  MBaseObjectPtr BaseObj;
  MSceneObjectPtr DeformObj, rootBoneObj;
  MTreeObjectNodePtr RootBoneNode, DeformObjNode;
  
  RootBoneNode = NULL;
  
  // Find the bone objects first
  {
    // go through the selected object list until we hit a bone, then take the
    // most parent bone that is selected
    
    g_Scene->getSelectedObjectList()->beginIteration();
    while ((BaseObj = g_Scene->getSelectedObjectList()->getNext()) != NULL) {
      if (getBoneObject(BaseObj) != NULL) {
        rootBoneObj = AZTEC_CAST(MSceneObject, BaseObj);
      }
    }
    g_Scene->getSelectedObjectList()->endIteration();
    
    if (rootBoneObj == NULL) {
      g_SysMan->logOutput("Error: KDeformAttachBones - Must have a Bone object selected.");
      return 0;
    }
    
    RootBoneNode = g_Scene->getObjectList()->findObject(rootBoneObj);
    
    if (RootBoneNode == NULL) {
      g_SysMan->logOutput("Error: KDeformAttachBones - Could not find Tree node for Bone object '%s'", (LPCTSTR)rootBoneObj->getName());
      return 0;
    }
    
    // Traverse up the tree so we get the most root bone who is still selected
    while (RootBoneNode->getParent() != NULL) {
      MBoneObjectPtr ParentBone;

      if (getBoneObject(RootBoneNode->getParent()->getObject()) == NULL) {
        break;
      }
      if (!RootBoneNode->getParent()->getObject()->isFlagged(OBJECTFLAG_SELECTED)) {
        break;
      }
      RootBoneNode = RootBoneNode->getParent();
    }
    rootBoneObj = AZTEC_CAST(MSceneObject, RootBoneNode->getObject());
    
    g_SysMan->logOutput("Debug: KDeformAttachBones - Found root bone node '%s'", (LPCTSTR) rootBoneObj->getName());
  }
  
  
  // Find the mesh objects in the selected list
  DeformObj = NULL;
  DeformObjNode = NULL;
  {
    g_Scene->getSelectedObjectList()->beginIteration();
    while ((BaseObj = g_Scene->getSelectedObjectList()->getNext()) != NULL) {
      DeformObj = AZTEC_CAST(MSceneObject, BaseObj);
      if (DeformObj == NULL) {
        continue;
      }

      // see if this is a mesh based object, ready to deform
      MMeshShapePtr meshShape = AZTEC_CAST(MMeshShape, DeformObj->getShapeObject());
      
      if (meshShape != NULL) {
        break;
      }
      
      DeformObj = NULL;
    }
    g_Scene->getSelectedObjectList()->endIteration();
    
    if (DeformObj == NULL) {
      g_SysMan->logOutput("Error: KDeformAttachBones - there was no Editable Mesh to deform.");

      return 0;
    }

    DeformObjNode = g_Scene->getObjectList()->findObject(DeformObj);
    if (DeformObjNode == NULL) {
      g_SysMan->logOutput("Error: KDeformAttachBones - Could not find Tree node for Deform object '%s'", (LPCTSTR)DeformObj->getName());

      return 0;
    }
    
    g_SysMan->logOutput("Debug: KDeformAttachBones - Found Deform Object node '%s'", (LPCTSTR) DeformObj->getName());
  }
  
  
  // Now we have to traverse the bone list, and split up the mesh according to the bones, and create and assign
  // cluster modifiers using those vertices.
  
  // This is gonna to be tough, will have to store a vertices current bone, and distance from it.
  
  // set up two planes, located at the start and end of each joint, with the normals coincident with the bone.
  // The two planes must face each other.
  
  // Just do the first bone for now.
  
  MTreeObjectNodePtr CurBoneNode, parentBoneObjNode;
  
  CurBoneNode = RootBoneNode;
  //   CurBoneNode = CurBoneNode->getFirstChild();
  
  KDeformAttachBones_CreateClusters(CurBoneNode, DeformObjNode);

  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KPrimitiveCreateBone() {
  MSceneObjectPtr sceneObj;
  MBoneObjectPtr NewBone;
  MBaseObjectPtr SelObj;
  MTreeObjectNodePtr ParentNode;
  
  SelObj = g_Scene->getSelectedObjectList()->getHead();
  ParentNode = g_Scene->getObjectList()->findObject(SelObj);

  sceneObj = new MSceneObject;
  NewBone = new MBoneObject;

  sceneObj->setShapeObject(NewBone);
  
  sceneObj->setName("bone");
  NewBone->setName("boneShape");
  g_Scene->addObject(sceneObj, ParentNode);
  
  g_Scene->selectNone();
  g_Scene->selectObject(sceneObj);
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}



int KSelectParent()
{
  if (g_Scene->getNumSelectedObjects() == 0)
    return 0;
  
  MBaseObjectListPtr OldList;
  MBaseObjectPtr Obj;
  MTreeObjectNodePtr TreeNode, Parent;
  
  OldList = AZTEC_CAST(MBaseObjectList, g_Scene->getSelectedObjectList()->createNew());
  
  if (OldList == NULL)
    return 0;
  
  g_Scene->selectNone();
  
  OldList->beginIteration();
  
  while ((Obj = OldList->getNext()) != NULL) {
    TreeNode = g_Scene->getObjectList()->findObject(Obj);
    if (TreeNode == NULL)
      continue;
    
    Parent = TreeNode->getParent();
    
    if (Parent == NULL)
      Parent = TreeNode;
    
    g_Scene->selectObject(Parent->getObject());
  }
  OldList->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KSelectChild()
{
  if (g_Scene->getNumSelectedObjects() == 0)
    return 0;
  
  MBaseObjectListPtr OldList;
  MBaseObjectPtr Obj;
  MTreeObjectNodePtr TreeNode, Child;
  
  OldList = AZTEC_CAST(MBaseObjectList, g_Scene->getSelectedObjectList()->createNew());
  
  if (OldList == NULL)
    return 0;
  
  g_Scene->selectNone();
  
  OldList->beginIteration();
  
  while ((Obj = OldList->getNext()) != NULL) {
    TreeNode = g_Scene->getObjectList()->findObject(Obj);
    if (TreeNode == NULL)
      continue;
    
    Child = TreeNode->getFirstChild();
    if (Child == NULL)
      Child = TreeNode;
    
    g_Scene->selectObject(Child->getObject());
  }
  OldList->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KSelectPrevSibling()
{
  if (g_Scene->getNumSelectedObjects() == 0)
    return 0;
  
  MBaseObjectListPtr OldList;
  MBaseObjectPtr Obj;
  MTreeObjectNodePtr TreeNode, Sib;
  
  OldList = AZTEC_CAST(MBaseObjectList, g_Scene->getSelectedObjectList()->createNew());
  
  if (OldList == NULL)
    return 0;
  
  g_Scene->selectNone();
  
  OldList->beginIteration();
  
  while ((Obj = OldList->getNext()) != NULL) {
    TreeNode = g_Scene->getObjectList()->findObject(Obj);
    if (TreeNode == NULL) {
      continue;
    }
    
    Sib = TreeNode->getNextSibling();
    if (Sib == NULL) {
      // If Sib is NULL, we are at the end of the sibling list,
      // so we goto the start
      
      Sib = TreeNode;
      while (Sib->getPrevSibling() != NULL) {
        Sib = Sib->getPrevSibling();
      }
      
      if (Sib == NULL)
        continue;
    }
    
    g_Scene->selectObject(Sib->getObject());
  }
  OldList->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KSelectNextSibling()
{
  if (g_Scene->getNumSelectedObjects() == 0)
    return 0;
  
  MBaseObjectListPtr OldList;
  MBaseObjectPtr Obj;
  MTreeObjectNodePtr TreeNode, Sib;
  
  OldList = AZTEC_CAST(MBaseObjectList, g_Scene->getSelectedObjectList()->createNew());
  
  if (OldList == NULL)
    return 0;
  
  g_Scene->selectNone();
  
  OldList->beginIteration();
  
  while ((Obj = OldList->getNext()) != NULL) {
    TreeNode = g_Scene->getObjectList()->findObject(Obj);
    if (TreeNode == NULL)
      continue;
    
    Sib = TreeNode->getPrevSibling();
    if (Sib == NULL) {
      // If Sib is NULL, that means we are at the start of the sibling list
      // Traverse to the end of the list
      Sib = TreeNode;
      while (Sib->getNextSibling() != NULL) {
        Sib = Sib->getNextSibling();
      }
      
      if (Sib == NULL)
        continue;
    }
    
    g_Scene->selectObject(Sib->getObject());
  }
  OldList->endIteration();
  
  OldList = NULL;
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

// Sets the parent of all the objects in the selection to the first object
// that was selected
int KParentSelection()
{
  MBaseObjectPtr Obj;
  MBaseObjectPtr parentObj;
  MBaseObjectListPtr SelList;
  SelList = g_Scene->getSelectedObjectList();
  
  parentObj = SelList->getTail();

  MSceneObject *parent = AZTEC_CAST(MSceneObject, parentObj);
  
  if (parent != NULL) {

    SelList->beginIteration();
    while ((Obj = SelList->getNext()) != NULL) {
      MSceneObject *child = AZTEC_CAST(MSceneObject, Obj);

      if (child != NULL && parent != NULL) {
        child->setParent(parent);
      }
    }
    SelList->endIteration();
  
    ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
    ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  }  
  return 1;
}

int KUnparentSelection()
{
  MBaseObjectPtr Obj;
  MBaseObjectListPtr SelList;
  
  SelList = g_Scene->getSelectedObjectList();
  
  SelList->beginIteration();
  while ((Obj = SelList->getNext()) != NULL) {
    MSceneObject *child = AZTEC_CAST(MSceneObject, Obj);

    if (child == NULL) {
      continue;
    }

    child->setParent(NULL);
  }
  SelList->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  
  return 1;
}


int KAssignMaterialToSelection()
{
  MMaterialPtr Material;
  MBaseObjectPtr Obj;
  
  Material = NULL;
  
  // Go throguh selection, and see if there are any materials selected
  g_Scene->getObjectList()->beginIteration();
  while ((Obj = g_Scene->getObjectList()->getNext()) != NULL) {
    if (!Obj->isFlagged(OBJECTFLAG_SELECTED))
      continue;
    
    Material = AZTEC_CAST(MMaterial, Obj);
    if (Material == NULL)
    {
      Material = AZTEC_CAST(MMaterial, g_Scene->getObjectList()->findObject(g_MaterialToAssign));
      if (Material == NULL)
        continue;
    }
    
    break;
  }
  g_Scene->getObjectList()->endIteration();
  
  if (Material == NULL)
  {
    g_SysMan->logOutput("KAssignMaterialToSelection: Error - No Material Selected");
    return 0;
  }
  
  g_Scene->getObjectList()->beginIteration();
  while (( Obj = g_Scene->getObjectList()->getNext() ) != NULL )
  {
    MTreeObjectNodePtr Node;
    
    Node = g_Scene->getObjectList()->getCurrentNode();
    
    if (Node->isChildOfFlagged(OBJECTFLAG_SELECTED))
    {
      MSceneObjectPtr SceneObj;
      
      SceneObj = AZTEC_CAST(MSceneObject, Obj);
      
      if (SceneObj == NULL)
        continue;
      SceneObj->setTextureMaterial(Material);
      
    }
  }
  g_Scene->getObjectList()->endIteration();

  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

	