// ToolConfigDlg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "AztecMain.h"
#include "ToolConfigDlg.h"

#include "MdlGlobs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TOOLCONFIG_CONTROL_BASE     20000

class CToolConfigItem;

typedef MRefCountedPtr<CToolConfigItem> CToolConfigItemPtr;

//----------------------------------------------------------------------------------------
//  CToolConfigItem
//----------------------------------------------------------------------------------------
class CToolConfigItem : public MBaseObject {
public:
  MParameterObjectPtr  m_Var;
  CEdit                *m_NameEdit, *m_ValueEdit;
  CSliderCtrl          *m_SliderCtrl;
  CButton              *m_CheckBox;
  
  CToolConfigItem();
  virtual ~CToolConfigItem();
  
  int SetVariable(MParameterObjectPtr Var);
  int CreateControls(CToolConfigDlg *Owner, int YPos);
  void MoveControls(int YPos);
  void DeleteControls();
  
  void UpdateVariable();
};

//----------------------------------------------------------------------------------------
//  CToolConfigDlg dialog
//----------------------------------------------------------------------------------------

CToolConfigDlg::CToolConfigDlg(CWnd* pParent) : CDialog(CToolConfigDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CToolConfigDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

   m_NextCtrlID = TOOLCONFIG_CONTROL_BASE;
   m_CurYPos = 8;
   m_ParamList = new MBaseObjectList;
}


void CToolConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CToolConfigDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CToolConfigDlg, CDialog)
	//{{AFX_MSG_MAP(CToolConfigDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CToolConfigDlg::SetToolName(const MStr &Name)
{
   m_ToolName = Name;

   ::SetWindowText(m_hWnd, (LPCTSTR)Name);
}

void CToolConfigDlg::AddParameter(MParameterObjectPtr Var)
{
   CToolConfigItem      *Item;

   Item = new CToolConfigItem;
   Item->SetVariable(Var);
   Item->CreateControls(this, m_CurYPos);

   m_CurYPos += 25;

   m_ParamList->addTail(Item);
}

UINT CToolConfigDlg::GetUnusedControlID()
{
   return m_NextCtrlID++;
}

CEdit* CToolConfigDlg::CreateEditBox(int Left, int Top, int Width, int Height, UINT Styles, DWORD FontStyle)
{
   CEdit    *Edit;
   HFONT    hFont;

   Edit = new CEdit;
   Edit->Create(ES_AUTOHSCROLL | Styles, CRect(Left,Top,Left+Width,Top+Height), this, GetUnusedControlID());

   hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);

   hFont = ::CreateFont(10, 0, 0, 0, FontStyle, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "MS Sans Serif");
   Edit->SendMessage(WM_SETFONT, (UINT)hFont, 0);
   Edit->ShowWindow(SW_SHOW);

   return Edit;
}

CButton* CToolConfigDlg::CreateButton(int Left, int Top, int Width, int Height, UINT Styles, DWORD FontStyle)
{
   CButton  *Button;
   HFONT    hFont;

   Button = new CButton;
   Button->Create("But", Styles, CRect(Left,Top,Left+Width,Top+Height), this, GetUnusedControlID());

   hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);

   hFont = ::CreateFont(10, 0, 0, 0, FontStyle, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "MS Sans Serif");
   Button->SendMessage(WM_SETFONT, (UINT)hFont, 0);
   Button->ShowWindow(SW_SHOW);

   return Button;
}

LRESULT CToolConfigDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
   if (message == WM_COMMAND)
   {
      UINT     ControlID;
      
      ControlID = LOWORD(wParam);

      if (ControlID == IDC_CANCELBUT)
         PostMessage(WM_CLOSE);

      if (ControlID == IDC_APPLYBUT || ControlID == IDC_OKBUT || ControlID == IDC_DOACTIONBUT) {
         // Apply settings
         {
            MBaseObjectPtr Obj;

            m_ParamList->beginIteration();
            while ((Obj = m_ParamList->getNext()) != NULL) {
               CToolConfigItemPtr Item;

               Item = AZTEC_CAST(CToolConfigItem, Obj);

               Item->UpdateVariable();
			   MStr valStr;
			   if (Item->m_Var->getValueString(valStr)) {
				g_ProgSet.SetToolParameter(m_ToolName, Item->m_Var->getLongName().c_str(),
					valStr.c_str());
			   }
            }
            m_ParamList->endIteration();
         }


         if (ControlID == IDC_DOACTIONBUT) {
            g_KeyList.ExecuteAction(m_ToolName);
         }

         if (ControlID == IDC_OKBUT)
            PostMessage(WM_CLOSE);
      }
   }
   else if (message == WM_CLOSE)
   {
      m_ParamList->removeAllNodes();
      DestroyWindow();
      delete this;
      return 1;
   }
   else if (message == WM_WINDOWPOSCHANGING || message == WM_WINDOWPOSCHANGED)
   {
      int         ButHeight;
      float       MarginWidth;
      HWND        hButton;
      RECT        ButRect;
      WINDOWPOS   *WndPos;

      WndPos = (WINDOWPOS*)lParam;

      if (!(WndPos->flags & SWP_NOSIZE))
      {
         hButton = ::GetDlgItem(m_hWnd, IDC_DOACTIONBUT);
         ::GetWindowRect(hButton, &ButRect);
         ::MapWindowPoints(HWND_DESKTOP, m_hWnd, (POINT*)&ButRect, 2);

         ButHeight = ButRect.bottom - ButRect.top;
         ButRect.top = WndPos->cy - ButHeight - 8 - GetSystemMetrics(SM_CYCAPTION) - GetSystemMetrics(SM_CYSIZEFRAME);

         MarginWidth = (float)(WndPos->cx - 8 - GetSystemMetrics(SM_CXSIZEFRAME)) / 4;

         hButton = ::GetDlgItem(m_hWnd, IDC_DOACTIONBUT);
         ButRect.left = 4;
         ButRect.right = (int)(MarginWidth - 4);
         ::MoveWindow(hButton, ButRect.left, ButRect.top,(int)MarginWidth - 8,  ButHeight, TRUE);

         hButton = ::GetDlgItem(m_hWnd, IDC_APPLYBUT);
         ButRect.left = (int)(4 + MarginWidth);
         ::MoveWindow(hButton, ButRect.left, ButRect.top,(int)MarginWidth - 8,  ButHeight, TRUE);

         hButton = ::GetDlgItem(m_hWnd, IDC_OKBUT);
         ButRect.left = (int)(4 + 2*MarginWidth);
         ::MoveWindow(hButton, ButRect.left, ButRect.top,(int)MarginWidth - 8,  ButHeight, TRUE);

         hButton = ::GetDlgItem(m_hWnd, IDC_CANCELBUT);
         ButRect.left = (int)(4 + 3*MarginWidth);
         ::MoveWindow(hButton, ButRect.left, ButRect.top,(int)MarginWidth - 8,  ButHeight, TRUE);
      }
   }
	
	return CDialog::WindowProc(message, wParam, lParam);
}


BOOL CToolConfigDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CWnd::PreTranslateMessage(pMsg);
}

//----------------------------------------------------------------------------------------
//  CToolConfigItem
//----------------------------------------------------------------------------------------

CToolConfigItem::CToolConfigItem()
{
   m_NameEdit = NULL;
   m_ValueEdit = NULL;
   m_SliderCtrl = NULL;
   m_CheckBox = NULL;
   m_Var = NULL;
}

CToolConfigItem::~CToolConfigItem()
{
   DeleteControls();
}

int CToolConfigItem::SetVariable(MParameterObjectPtr Var)
{
   m_Var = Var;

   return 1;
}

int CToolConfigItem::CreateControls(CToolConfigDlg *Owner, int YPos)
{
   if (!Owner)
      return 0;

   MStr tstr;

   if (m_Var->getDataType() == MParameterObject::TYPE_INTEGER)
   {
      m_NameEdit = Owner->CreateEditBox(2,2,2,2, ES_RIGHT | ES_READONLY);
      m_ValueEdit = Owner->CreateEditBox(2,2,2,2);

	  m_Var->getLongName();
      m_NameEdit->SetWindowText(m_Var->getShortName().c_str());
	  m_Var->getValueString(tstr);
      m_ValueEdit->SetWindowText(tstr.c_str());

      MoveControls(YPos);
   }
   if (m_Var->getDataType() == MParameterObject::TYPE_FLOAT)
   {
      m_NameEdit = Owner->CreateEditBox(2,2,2,2, ES_RIGHT | ES_READONLY);
      m_ValueEdit = Owner->CreateEditBox(2,2,2,2);

      m_NameEdit->SetWindowText(m_Var->getShortName().c_str());
	  m_Var->getValueString(tstr);
      m_ValueEdit->SetWindowText(tstr);

      MoveControls(YPos);
   }
   if (m_Var->getDataType() == MParameterObject::TYPE_BOOLEAN)
   {
      RECT     Rect;

      Rect.left = 2;
      Rect.right = 4;
      Rect.top = 2;
      Rect.bottom = 4;

      m_CheckBox = Owner->CreateButton(2,2,2,2, BS_AUTOCHECKBOX);

      m_CheckBox->SetWindowText(m_Var->getShortName().c_str());
	  bool tbool;
	  m_Var->getValueBoolean(tbool);
      m_CheckBox->SetCheck(tbool);

      MoveControls(YPos);
   }
   
   return 1;
}

void CToolConfigItem::MoveControls(int YPos)
{
   RECT     Rect;

   Rect.top = YPos;
   Rect.bottom = YPos + 17;
   

   if (m_NameEdit)
   {
      Rect.left = 8;
      Rect.right = 108;
      m_NameEdit->MoveWindow(&Rect, TRUE);
   }

   if (m_ValueEdit)
   {
      Rect.left = 116;
      Rect.right = 216;
      m_ValueEdit->MoveWindow(&Rect, TRUE);
   }
   if (m_CheckBox)
   {
      Rect.left = 8;
      Rect.right = 200;
      m_CheckBox->MoveWindow(&Rect, TRUE);
   }
}

void CToolConfigItem::DeleteControls()
{
   if (m_NameEdit)
   {
      m_NameEdit->DestroyWindow();
      delete m_NameEdit;
      m_NameEdit = NULL;
   }
   if (m_ValueEdit)
   {
      m_ValueEdit->DestroyWindow();
      delete m_ValueEdit;
      m_ValueEdit = NULL;
   }
   if (m_SliderCtrl)
   {
      m_SliderCtrl->DestroyWindow();
      delete m_SliderCtrl;
      m_SliderCtrl = NULL;
   }
   if (m_CheckBox)
   {
      m_CheckBox->DestroyWindow();
      delete m_CheckBox;
      m_CheckBox = NULL;
   }
}

void CToolConfigItem::UpdateVariable()
{
   if (m_Var->getDataType() == MParameterObject::TYPE_INTEGER)
   {
      char  Value[256];

      m_ValueEdit->GetWindowText(Value, 255);

      m_Var->setValueInteger(atoi(Value));
   }
   if (m_Var->getDataType() == MParameterObject::TYPE_FLOAT)
   {
      char  Value[256];

      m_ValueEdit->GetWindowText(Value, 255);

      m_Var->setValueFloat(atof(Value));
   }
   if (m_Var->getDataType() == MParameterObject::TYPE_BOOLEAN)
   {
      bool Checked = (m_CheckBox->GetCheck() != 0);
      m_Var->setValueBoolean(Checked);
   }
}
