#ifndef SegmentViewWnd_Header
#define SegmentViewWnd_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SceneViewWnd.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CSegmentViewWnd window

#include "BaseViewWnd.h"
#include "SegmentEditor.h"
#include "ImageButton.h"

class CSegmentViewWnd : public MBaseViewWnd
{
// Construction
public:
	CSegmentViewWnd();

    // Class related
   virtual MStr getClassName() {return MStr("CSegmentViewWnd");};
   virtual MStr getParentClassName() {return MStr("MBaseViewWnd");};
   virtual MBaseObjectPtr createNew();

   virtual void ViewCreate();
   virtual void DrawView();

public:
  void zoomIn();
  void zoomOut();
  void scroll(int xAmount, int yAmount);

	virtual void onMouseUp(int X, int Y, MShiftState Shift);
	virtual void onMouseDown(int X, int Y, MShiftState Shift);
	virtual void onMouseMove(int x, int y, MShiftState Shift);

  virtual DWORD ViewPopupMenu(int x, int y);
  virtual int HandlePopupCommand(DWORD Cmd);

  CImageButton m_ZoomIn, m_ZoomOut;
  CScrollBar m_HorzScroll, m_VertScroll;
  bool m_Tracking;

protected:
  CSegmentEditor m_SegmentEditor;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSegmentViewWnd)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSegmentViewWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(CSegmentViewWnd)
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnClose();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif SegmentViewWnd_Header
