#ifndef MDLMESSAGES_H
#define MDLMESSAGES_H

// Control base constants
#include "resource.h"

// if we are using dev studio id's, use the last value to 
// help us with our menu id's, to ensure they are unique.
#ifdef _APS_NEXT_COMMAND_VALUE
#define MM_MATERIALS_MENUBASE       _APS_NEXT_COMMAND_VALUE+100
#define MM_PRIMITIVES_MENUBASE      _APS_NEXT_COMMAND_VALUE+500
#else
#define MM_MATERIALS_MENUBASE       60000
#define MM_PRIMITIVES_MENUBASE      59000
#endif

// constants for the MM_UPDATEVIEWPORTS message
#define MMC_UPDATE_XY   0x0001
#define MMC_UPDATE_XZ   0x0002
#define MMC_UPDATE_ZY   0x0004
#define MMC_UPDATE_XYZ  0x0007
#define MMC_UPDATE_CAM  0x0008
#define MMC_UPDATE_SKIN 0x0010

#define MMC_UPDATE_ALL  0xFFFF

#define MMC_UPDATE_DEPENDANTS 0x0001

#define MMC_NOSCROLL    0x01


#define MMC_XLABEL           0x01
#define MMC_YLABEL           0x02
#define MMC_ZLABEL           0x04
#define MMC_GRIDLABEL        0x08
#define MMC_SELECTCOUNTERS   0x10

#define MM_STOPPLAY              WM_USER+8001
#define MM_STARTPLAY             WM_USER+8002


#define MM_FILENAMECHANGED       WM_USER+8003

#define MM_UPDATEVIEWPORTS       WM_USER+8004
// Sent to a window to indicate that some or all of the view ports need updating
// wparam:  MMC_UPDATE_XY     updates the XY view
//          MMC_UPDATE_XZ     updates the XZ view
//          MMC_UPDATE_ZY     updates the ZY view
//          MMC_UPDATE_CAM    updates the Camera view.
//          MMC_UPDATE_SKIN   updates the skin if aplicable (For Skin Editor)
// lparam: MMC_UPDATE_DEPENDANTS    updates the skin, or 3d view, or painter view if required


#define MM_UPDATEFEEDBACK        WM_USER+8005
// This updates all or some of the bottom bits of data on the bottom dialog. Like
// XYZ positiuon, GirdSize, ScrollBar Pos etc.
// wParam:  MMC_XLABEL           updates the X feedback
//          MMC_YLABEL           updates the Y feedback
//          MMC_ZLABEL           updates the Z feedback
//          MMC_GRIDLABEL        updates the Gird feedback
//          MMC_SELECTCOUNTERS   updates the selection counters.

#define MM_UPDATECHANNELBAR      WM_USER+8006
// Sent to the main window to update the current channel bar.


#endif