#ifndef MMenuBar_Header
#define MMenuBar_Header

class MMenuBar : public CWnd
{
public:
  /**
   * This interface class is used to create and destroy popup menus. An 
   * interface class was chosen to do this, instead of using resource, 
   * because it odffers a good way of having dynamically created 
   * popupmenus, as well as an easy way to have resource created menus.
   */
  class MenuCreator {
  public:
    virtual HMENU createMenu() = 0;
    virtual void destroyMenu(HMENU) = 0;
  };

  /**
   * This class is an implementation of the MenuCreator interface that creates
   * a popup menu based on a resource that contains a popup menu. IT is
   * expected that the resource has a root menu item, then all the popup menu
   * items are under that one.
   */
  class PopupMenu : public MenuCreator {
  public:
    PopupMenu(DWORD resource);

    HMENU createMenu();
    void destroyMenu(HMENU menu);

  private:
    DWORD menuResource;
    HMENU parentMenu;
  };




	MMenuBar(bool menuBar = true);
	~MMenuBar();

  void addMenu(const std::string &name, HMENU menu, int index = -1);
  void addMenu(const std::string &name, MenuCreator *creator, int index = -1);

  /**
   * This calculates the menu's height given the width we are allowed
   */
  int getMenuHeight();

  /**
   * This tells the menu to use the same size for each menu item, or to 
   * calculate the size of each item separately.
   */
  void setCommonSize(bool commonSize);

  int getLargestWidth(HDC dc = NULL);

  BOOL onMenuInput(MSG* pMsg);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTimeScroller)
	protected:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
  virtual BOOL OnCommand( WPARAM wParam, LPARAM lParam );
	//}}AFX_VIRTUAL

	// Generated message map functions
protected:

  void drawMenuItems(HDC dc);
  void setHilightedMenu(int index, int changeOpeningMenu = -1);
  int getItemFromPos(int x, int y);
  void showMenu(int index);
  void calcItemSizes(HDC dc = NULL);
  void layoutItems(HDC dc = NULL);

  class MenuItem {
  public:
    typedef enum { Normal, Hilighted, Selected } MenuState;

    MenuItem(const std::string &text, HMENU newMenu);
    MenuItem(const std::string &text, MenuCreator *menuCreator);
    MenuItem(const MenuItem &src);
    ~MenuItem();

    HMENU getMenu();
    void finishedWithMenu(HMENU menu);


    std::string caption;
    RECT rect;
    int width;
    int height;
    HMENU menu;
    MenuCreator *creator;
  };

  typedef std::vector<MenuItem*> ItemVector;

  ItemVector items;
  int hilightedMenu;
  bool openingMenus;
  bool constantSize;
  int itemHeight;
  int lastRowCount;
  bool hilight3D;
  bool centreText;
  bool isMenuBar;
  BOOL m_bTrack;
  bool useXPColours;

  std::string name;

  friend DWORD WINAPI showMenuProc(LPVOID lpParameter);

	//{{AFX_MSG(CTimeScroller)
	afx_msg void OnPaint();
  afx_msg void OnSize( UINT nType, int cx, int cy );
  afx_msg void OnDestroy();
	afx_msg LRESULT OnPopupMenu(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TIMESCROLLER_H__2C259AD6_11AE_11D3_8452_0040332C7B2F__INCLUDED_)
