#if !defined(AFX_CHANNELBAR_H__E954E4D1_15C0_11D3_845B_0040332C7B2F__INCLUDED_)
#define AFX_CHANNELBAR_H__E954E4D1_15C0_11D3_845B_0040332C7B2F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "MdlMsgs.h"
#include "MScene.h"
#include "MStr.h"
#include "MdlConst.h"
#include "AztecGUIMParameterPlugin.h"
#include <controls/MMenuBar.h>

#define _WTL_NO_AUTOMATIC_NAMESPACE

// This code is here, extracted from commctrl.h because ATL and MFC do not
// exist happily together, include file wise.
#ifdef __IStream_INTERFACE_DEFINED__
WINCOMMCTRLAPI HIMAGELIST WINAPI ImageList_Read(LPSTREAM pstm);
WINCOMMCTRLAPI BOOL       WINAPI ImageList_Write(HIMAGELIST himl, LPSTREAM pstm);
#endif
 
#include <commctrl.h>

#include <atlapp.h>
#include <atlwin.h>

// ARE: atlctrls.h doesn't seem to compile correctly on Windows XP if you don't
// also have a reference to "IStream", which is defined in ObjIdl.h.
// #include <atlctrls.h>

#include <vector>

class MChannelLabel;
class MChannelParameter;
class CChannelParamWnd;
class CChannelBar;

typedef MRefCountedPtr<MChannelLabel> MChannelLabelPtr;
typedef MRefCountedPtr<MChannelParameter> MChannelParameterPtr;

//----------------------------------------------------------------------------------------
//  MChannelLabel
//----------------------------------------------------------------------------------------
class MChannelLabel : public MRefCountedObject {
public:
   static int  m_FontSize;

   HWND     m_hParent;
   MStr     m_String;
   RECT     m_Rect;
   bool     m_Selected, m_Visible;

   MChannelLabel();

   void SetParent(HWND hParent);

   void SetWindowText(LPCTSTR lpszString);
   void GetWindowText(CString Str);

   void Draw(HDC hDC = NULL);
   void MoveWindow(RECT *lpRect, BOOL Repaint);

   bool MouseIn(int X, int Y);
};

class MChannelWindow : public ATL::CWindowImpl<MChannelWindow> {
public:
	MChannelWindow();
	virtual ~MChannelWindow();
	
	HWND m_hParent;

protected:
	BEGIN_MSG_MAP(MChannelComboWindow)
		MESSAGE_HANDLER(WM_KEYDOWN, OnKeyDown)
	END_MSG_MAP()

	LRESULT OnKeyDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
};

//----------------------------------------------------------------------------------------
//  MChannelParameter
//----------------------------------------------------------------------------------------
class MChannelParameter : public MRefCountedObject {
public:
  MChannelParameter();
  ~MChannelParameter();
  
  void setFromParameterObject(MParameterObjectPtr param);
  void CreateControls(CChannelParamWnd *Owner, int Y, float MidMargin = 0.4, int RightMargin = 0);
  void UpdateControls();
  void DeleteControls();
  void MoveControls(int Y, float MidMargin, int RightMargin = 0);
  
  MChannelWindow *getControl();
  
  void setParamName(const MStr &name);
  void setDisplayName(const MStr &name);
  
  MStr getParamName();
  MStr getDisplayName();
  
  void setValue(const MStr &str);
  MStr getValue();

  void setSelectedObject(MNamedObjectPtr obj);
  MNamedObjectPtr getSelectedObject();  

  MParameterObjectPtr getParameterObject();

  void focusControl();
  
  void setLabelVisible(bool visible);
  MChannelLabelPtr getLabel() {return m_NameLabel;}

  void makeParameterChange();

  COLORREF getEditColour();

  // Get the height and width this parameter will use in the channel bar
  int getHeight();
  void setHeight(int h);
  int getWidth();
  void setWidth(int w);

  // Get/Set custom (plugin) editor property
  AztecGUI::MParameterPluginPtr getCustomEditor();
  void setCustomEditor(AztecGUI::MParameterPluginPtr cust);
  MChannelWindow *getCustomControl();
  void setCustomControl(MChannelWindow *cust);


protected:
  MStr           m_ParamName, m_DisplayName, m_ParamValue;
  int m_Height, m_Width;

  MParameterObjectPtr m_Param;
  MChannelLabelPtr m_NameLabel;

  // We maintain a pointer to the actual edit control, or to a plugin editor.  Only one
  // of the two following members (m_ParamControl, m_CustomParamControl) will be non-NULL.
  MChannelWindow *m_ParamControl;
  MChannelWindow *m_CustomParamControl;
  AztecGUI::MParameterPluginPtr m_CustomParamEditor;

  
  MNamedObjectPtr    m_Object;

  COLORREF editColour;
};


//----------------------------------------------------------------------------------------
//  CChannelParamWnd
//----------------------------------------------------------------------------------------
class CChannelParamWnd : public ATL::CWindowImpl<CChannelParamWnd>
{
public:
	CChannelParamWnd();
	virtual ~CChannelParamWnd();

   HWND m_NameEdit;
   HFONT m_hFont;
   std::vector<MChannelParameterPtr> m_Params;
   MNamedObjectPtr      m_LastObject, m_Object;
   MShiftState          m_ShiftState;
   int                  m_SelFrom, m_SelTo;

   UINT GetUnusedControlID();
   MChannelWindow *CreateEditBox(int Left, int Top, int Width, int Height, UINT Styles = 0, DWORD FontStyle = FW_NORMAL);
   MChannelWindow *CreateComboBox(int Left, int Top, int Width, int Height, UINT Styles = 0, DWORD FontStyle = FW_NORMAL);
   MChannelWindow *CreateButton(int Left, int Top, int Width, int Height, UINT Styles = 0, DWORD FontStyle = FW_NORMAL);

   void UpdateAllParams();
   void DeleteAllParams();
   void UpdateParamSelection(bool ClearSel = true);
   
   void DoPopup(int X, int Y);
   void InitPopup(HMENU Popup, MChannelParameterPtr ChanParam);
   void ProcessPopup(DWORD MenuID, MChannelParameterPtr ChanParam);


   void AddParameter(MChannelParameterPtr Param);
   int GetChannelParamNumFromPoint(int X, int Y);
   int getNumParamObjects();

   // Scrolling window stuff
	void GetChildExtents(HWND hParent, RECT *lpRect);
	void GetChildExtents(RECT *lpRect);

  void setMarkForDeletion(bool value);
  bool isMarkedForDeletion();

protected:
  bool m_MarkForDelete;
	int AddNameControl(MNamedObjectPtr SelectedObj, RECT &rect, int Y);
	int AddStockControls(MNamedObjectPtr SelectedObj, RECT &rect, int Y);
	int AddCustomControls(MNamedObjectPtr SelectedObj, RECT &rect, int Y);

  HBRUSH getBrushForHWnd(HWND hWnd, HDC hdc);
  MChannelParameter* getChannelParameterForHWnd(HWND hWnd);

	// Generated message map functions
protected:
	BEGIN_MSG_MAP(CChannelParamWnd)
		// MESSAGE_RANGE_HANDLER(0, 0x0400, OnAllMessages)
		COMMAND_CODE_HANDLER(CBN_SELCHANGE, OnComboBoxChange)
		// MESSAGE_HANDLER(WM_COMMAND, OnCommand)
		MESSAGE_HANDLER(WM_DESTROY, OnPaint)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBackground)
		MESSAGE_HANDLER(WM_LBUTTONDOWN, OnLButtonDown)
		MESSAGE_HANDLER(WM_LBUTTONDBLCLK, OnLButtonDblClk)
		MESSAGE_HANDLER(WM_MOUSEMOVE, OnMouseMove)
		MESSAGE_HANDLER(WM_RBUTTONDOWN, OnRButtonDown)
		MESSAGE_HANDLER(WM_LBUTTONUP, OnLButtonUP)
		MESSAGE_HANDLER(WM_MBUTTONDOWN, OnMButtonDown)
		MESSAGE_HANDLER(WM_MBUTTONUP, OnMButtonUp)
		MESSAGE_HANDLER(WM_RBUTTONUP, OnRButtonUp)
		MESSAGE_HANDLER(WM_KEYDOWN, OnKeyDown)
    MESSAGE_HANDLER(WM_CTLCOLOREDIT, OnGetEditControlColour);
	END_MSG_MAP()

	LRESULT OnAllMessages(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnCommand(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnComboBoxChange(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnPaint(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
  LRESULT OnEraseBackground(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonDblClk(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnRButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonUP(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMButtonUp(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnRButtonUp(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnKeyDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
  LRESULT OnGetEditControlColour(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
};

class ChannelGroup : public MRefCountedObject {
public:
  typedef std::vector<CChannelParamWnd*> ChannelParamVector;
  typedef enum { Category_Normal, Category_Input, Category_Output } Category;

  ChannelGroup(CChannelBar *channelBar, const MNamedObjectPtr &object);
//  ChannelGroup(const ChannelGroup &src);
  ~ChannelGroup();

  MNamedObjectPtr getObject();

  void organiseGroup(int top, int width);
  int getHeight();
  void updateWindow();

  int getInputLabelPos();
  int getOutputLabelPos();

  void setMarkForDeletion(bool value);
  bool isMarkedForDeletion();
  const ChannelParamVector& getAllWindows();

  void collapseAll();
  void expandAll();
protected:
  CChannelBar *channelBar;
  MNamedObjectPtr object;
  ChannelParamVector allObjects;
  ChannelParamVector normalObjects;
  ChannelParamVector inputObjects;
  ChannelParamVector outputObjects;

  int lastGroupHeight;

  int inputLabelPos;
  int outputLabelPos;

  bool shouldDelete;
  
  void addObject(const MNamedObjectPtr &object, Category category);
  CChannelParamWnd* addObjectControls(const MNamedObjectPtr &object);

  ChannelParamVector* getParamVectorFor(const MNamedObjectPtr &object);
  typedef std::map<MNamedObjectPtr, Category> CategoryMap;
  CategoryMap categoryMap;

  void organiseGroups(ChannelParamVector &group, int &ypos, int width);
  void moveGroup(CChannelParamWnd* window, int &yPos, int width);

};

typedef MRefCountedPtr<ChannelGroup> ChannelGroupPtr;


//----------------------------------------------------------------------------------------
//  CChannelBar
//----------------------------------------------------------------------------------------
class CChannelBar : public ATL::CWindowImpl<CChannelBar>
{
// Construction
public:
   // enum { IDD = IDD_CHANNELBAR_DIALOG };

  typedef std::vector<ChannelGroupPtr> ChannelGroupList;
  ChannelGroupList channelGroups;
  MBaseObjectPtr m_LastSelected;

  CChannelBar();
   
   // Scrolling window stuff
	void GetChildExtents(HWND hParent, RECT *lpRect);
	void GetChildExtents(RECT *lpRect);
  void UpdateAllParams();
  void DeleteAllParams();
  
  void InvalidateScrollRect();

  void setCurrentObject(const MNamedObjectPtr &object);
  MNamedObjectPtr getCurrentObject();
  
  bool     m_VerticalScroll, m_HorizontalScroll;

protected:
  /**
   * Adds a parameter to the list of known parameter and creates a nice
   * lil' window for it. Returns true if the parameter was added, false
   * if it wasn't (i.e, is already there).
   */
   CChannelParamWnd* doAddParam(MNamedObjectPtr Obj);
   void addObject(const MNamedObjectPtr &obj);
   void DeleteMarkedParams();

   void OrganiseGroups();

   MNamedObjectPtr currentObject;

// Implementation
public:
	virtual ~CChannelBar();

	// Generated message map functions
protected:
	BEGIN_MSG_MAP(CChannelBar)
		MESSAGE_HANDLER(MM_UPDATECHANNELBAR, OnUpdateChannelBar);
		MESSAGE_HANDLER(WM_KEYDOWN, OnKeyDown)
		MESSAGE_HANDLER(WM_LBUTTONDOWN, OnLButtonDown)
		MESSAGE_HANDLER(WM_LBUTTONUP, OnLButtonUP)
		MESSAGE_HANDLER(WM_MBUTTONDOWN, OnMButtonDown)
		MESSAGE_HANDLER(WM_MBUTTONUP, OnMButtonUp)
		MESSAGE_HANDLER(WM_SIZE, OnSize)
		MESSAGE_HANDLER(WM_WINDOWPOSCHANGED, OnWindowPosChanged)
		MESSAGE_HANDLER(WM_WINDOWPOSCHANGING, OnWindowPosChanging)
		MESSAGE_HANDLER(WM_MOUSEMOVE, OnMouseMove)
		MESSAGE_HANDLER(WM_MOUSEWHEEL, OnMouseWheel)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBackground)
	END_MSG_MAP()

	LRESULT ProcessSizingMsg(WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	bool     m_Dragging;
	int      m_OldX, m_OldY, m_ScrollX, m_ScrollY;
	
	LRESULT OnUpdateChannelBar(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnKeyDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonUP(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMButtonUp(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnSize(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnWindowPosChanged(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnWindowPosChanging(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMouseWheel(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnPaint(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
  LRESULT OnEraseBackground(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
};

class CChannelBarContainer : public ATL::CWindowImpl<CChannelBarContainer> {
public:

	LRESULT ProcessSizingMsg(WPARAM wParam, LPARAM lParam, BOOL& bHandled);

	BEGIN_MSG_MAP(CChannelBar)
		MESSAGE_HANDLER(WM_CREATE, OnCreate)
		MESSAGE_HANDLER(WM_SIZE, OnSize)
		MESSAGE_HANDLER(WM_WINDOWPOSCHANGED, OnWindowPosChanged)
		MESSAGE_HANDLER(WM_WINDOWPOSCHANGING, OnWindowPosChanging)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBackground)
		MESSAGE_HANDLER(WM_COMMAND, OnCommand)
	END_MSG_MAP()

  LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnWindowPosChanged(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnWindowPosChanging(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnSize(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnPaint(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnEraseBackground(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
  LRESULT OnCommand(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);

  CChannelBar channelBar;
  MMenuBar menuBar;

public:
  typedef std::map<int, MNamedObject*> ObjectMap;

protected:
  ObjectMap objectMap;
};



/////////////////////////////////////////////////////////////////////////////
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHANNELBAR_H__E954E4D1_15C0_11D3_845B_0040332C7B2F__INCLUDED_)
