#include "StdAfx.h"

#include <params/MUniqueNameParameter.h>
#include <MSystemManager.h>

#include <assert.h>
#include <stdio.h>

#include <ctype.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  // TODO: this should be moved into the Scene class at some point.
  typedef std::map<std::string, MNamedObject*> AllNamesMap;
  AllNamesMap allNames;

  static std::string generateUniqueName(const std::string &basicName, const std::string &oldName);

  /// simple conversion routine to ease the paint going from Mstr to std::string
  static std::string strToStr(const MStr &str) {
    if (str.GetLength() > 0) {
      return str.c_str();
    } else {
      return "";
    }
  }

#ifdef _DEBUG
  /**
   * This is just a debugging routine to ensure that all the entries in the map are valid.
   */
  void checkNames() {
    AllNamesMap::iterator it;

    for (it = allNames.begin(); it != allNames.end(); ++it) {
      std::string name1, name2;

      name1 = it->first;

      if (it->second != NULL) {
        name2 = strToStr(it->second->getName());
      }
      assert(name1 == name2);
    }
  }

#endif

  //---------------------
  //  MUniqueNameParameter
  //---------------------


  MUniqueNameParameter::MUniqueNameParameter(
    MNamedObject *namedObject, 
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName) 
    : MStringParameterImpl(shortName, longName, friendlyName), namedObj(namedObject)
  {
  }


  
  MUniqueNameParameter::~MUniqueNameParameter()
  {
    MStr oldValue;

    getValueString(oldValue);

    std::string str;
    
    if (oldValue.GetLength() != 0) {
      str = oldValue.c_str();
    }

    AllNamesMap::iterator it = allNames.find(str);

    if (it != allNames.end()) {
      allNames.erase(it);
    }

  }

  bool MUniqueNameParameter::setValueString(const MStr &value) {
    MStr oldValueStr;
    std::string newValue = strToStr(value);
    std::string oldValue;

    // loop over our input value, and replace all non good characters with _
    for (unsigned int index = 0; index < newValue.length(); ++index) {
      if (!isalnum(newValue[index])) {
        newValue[index] = '_';
      }
    }
    

    getValueString(oldValueStr);

    // if nothing has changed, do nothing.
    if (newValue == strToStr(oldValueStr.c_str())) {
      return false;
    }

    oldValue = strToStr(oldValueStr);

    // generate a unique name based off what is currently in the scene.
    
    if (MSystemManager::getInstance()->getScene() == NULL) {
      return MStringParameterImpl::setValueString(newValue.c_str());
    }

    if (newValue.length() == 0) {
      newValue = generateUniqueName("Object", oldValue);
    } else {
      newValue = generateUniqueName(newValue.c_str(), oldValue);
    }

    // check for a redundant change again, because we might have ended up with
    // our original name.
    if (oldValue == newValue) {
      return false;
    }

    // try and find the old entry to get rid off
    AllNamesMap::iterator it;
    it = allNames.find(oldValue);

    if (it != allNames.end()) {
      allNames.erase(it);
    }

    // only bother adding in a name if the named object is known
    if (namedObj != NULL) {
      std::pair<AllNamesMap::iterator, bool> result;
      result = allNames.insert(AllNamesMap::value_type(newValue, namedObj));

      // make sure that the value was actually inserted, and not already found.
      assert(result.second == true);
    }

    bool r = MStringParameterImpl::setValueString(newValue.c_str());

#ifdef _DEBUG
//    checkNames();
#endif

    return r;
  }  

  static std::string generateUniqueName(const std::string &basicName, const std::string &oldName) {
    // Search for the occurance of prefix, and return the next number in the sequence if one already exists.
  
    int MaxObjNum;
    std::string ActualPrefix;
    std::set<std::string> matchingNames;

    // strip out trailing numbers from prefix.
    {
      char  *Name;
      int   n, ObjNum;
    
      Name = new char[basicName.length()+1];
      strcpy(Name, basicName.c_str());
    
      n = strlen(Name);
      while (n--) {
        if (!isdigit(Name[n])) {
          ObjNum = atoi(&Name[n+1]);
          Name[n+1] = '\x0';
          break;
        }
      }
    
      ActualPrefix = Name;
    
      delete[] Name;
    }

    bool nameFound = false;

    MaxObjNum = -1;

    AllNamesMap::iterator it;

    // first test to see if we have a unique name. If we already do, then no processing is requird.
    if (allNames.find(basicName) == allNames.end()) {
      return basicName;
    }

    // otherwise, we have to do some exhaustive searching. to find the next available name
    for (it = allNames.begin(); it != allNames.end(); ++it) {
      if (it->first.find(ActualPrefix) != std::string::npos) {
        matchingNames.insert(it->first);
      }
    }

    // now, starting at 1, we count upwards until we no longer have a match.
    int objNum = 1;
    char  NewName[512];

    while (1) {
      sprintf(NewName, "%s%i", ActualPrefix.c_str(), objNum);
      if (matchingNames.find(NewName) == matchingNames.end() ||
          oldName == NewName) {
        break;
      }
      objNum++;
    }

    return NewName;
  }


}


