#include "StdAfx.h"

#include <mesh/MMeshModifier.h>
#include <params/MParameterFactory.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MMeshModifier::MMeshModifier() {
    setObjectType(OBJECTFLAG_TYPE_MODIFIER);

    addParameter(inputShapeParam = MParameterFactory::createObject("in", "inMesh", "Input Mesh"));
  }

  MMeshModifier::~MMeshModifier() {
  }

  MMeshShapePtr MMeshModifier::getInputShape() {
    return AZTEC_CAST(MMeshShape, inputShapeParam->getValue());
  }

  MObjectParameterPtr MMeshModifier::getInputParameter() {
    return inputShapeParam;
  }
  
}
