#include "StdAfx.h"
#include "MUndoManager.h"
#include <MSystemManager.h>

#include <MDAGraph.h>

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MGENEXPORT void undoFlagOutputs(MRefCountedObject *dagnode) {
    MDAGNode *realnode = AZTEC_CAST(MDAGNode, dagnode);
    if (realnode != NULL) {
      MDAGraph::flagOutputs(realnode, OBJECTFLAG_NEEDS_UPDATE);
    }
  }

  MUndoManager* MUndoManager::getInstance() {
    return &*MSystemManager::getUndoManager();
  }


/*  UndoNodeList::UndoNodeList() {
  }

  UndoNodeList::UndoNodeList(const UndoNodeList &src) 
    : name(src.name), std::vector<MBaseUndoNodePtr>(src)
  {
  }

  void UndoNodeList::setName(const char *name) {
    this->name = name;
  }

  const char* UndoNodeList::getName() {
    return name.c_str();
  }
  */

  MUndoManager::MUndoManager() {
    m_MaxUndos = -1;
    undoDepth = 0;
    enabled = 0;
  }
  
  MUndoManager::~MUndoManager() {
    m_UndoStack.clear();
    m_RedoStack.clear();
  }
  
  bool MUndoManager::isEnabled() {
    return (getInstance() != NULL) && (getInstance()->undoDepth > 0);
  }

  void MUndoManager::addUndoNode(MBaseUndoNodePtr node) {
    if (undoDepth > 0) {
      currentNodeList.push_back(node);
    } else {
      node->getObject()->finishWithUndoNode();
    }
    
  }
  
  void MUndoManager::undo() {
    if (m_UndoStack.size() == 0) {
      return;
    }
    
    // Remove the node from the undo list
    UndoNodeList nodeList = m_UndoStack.back();
    m_UndoStack.pop_back();
    
    // Undo the node
    doNodeList(nodeList, true);
    
    m_RedoStack.push_back(nodeList);
    
  }

  void MUndoManager::redo() {
    if (m_RedoStack.size() == 0) {
      return;
    }
    
    MBaseUndoNodePtr  node;
    
    // Remove the node from the undo list
    UndoNodeList nodeList = m_RedoStack.back();
    m_RedoStack.pop_back();
    
    // Undo the node
    doNodeList(nodeList, false);
    
    m_UndoStack.push_back(nodeList);
    
  }
  
  MStr MUndoManager::getUndoDisplayName() {
    if (m_UndoStack.size() == 0) { 
      return "";
    }
    
//    return m_UndoStack.back().getName();
    return "node";
    
  }
  
  
  MStr MUndoManager::getRedoDisplayName() {
    if (m_RedoStack.size() == 0) { 
      return "";
    }
    
    
//    return m_RedoStack.back().getName();
    return "node";
    
  }
  
  void MUndoManager::clearUndoInfo() {
    m_UndoStack.clear();
    m_RedoStack.clear();
  }

  void MUndoManager::beginUndo(const std::string &name) {
    if (undoDepth == 0) {
      for (UndoNodeList::const_iterator it = currentNodeList.begin(); it != currentNodeList.end(); ++it) {
        MBaseUndoNodePtr node = (*it);
        MUndoableObject* obj = node->getObject();
        obj->finishWithUndoNode();
      }
      currentNodeList.clear();
    }

    ++undoDepth;
    //if (currentNodeList.size() != 0) {
//      endUndo();
    //}

  }

  void MUndoManager::endUndo() {
    // only bother doing anything if we ended up with some undo nodes.
    if (currentNodeList.size() > 0) {
      // now shift the current list onto the end of the undo list.
      m_RedoStack.clear();
      m_UndoStack.push_back(currentNodeList);

      // now iterate over the nodes and tell the obects we have finished with them
      for (UndoNodeList::const_iterator it = currentNodeList.begin(); it != currentNodeList.end(); ++it) {
        MBaseUndoNodePtr node = (*it);
        MUndoableObject* obj = node->getObject();
        obj->finishWithUndoNode();
      }

      currentNodeList.clear();
    }

    --undoDepth;
    assert(undoDepth >= 0);
  }
  
  void MUndoManager::doNodeList(const UndoNodeList &nodeList, bool undo) {
    for (UndoNodeList::const_iterator it = nodeList.begin(); it != nodeList.end(); ++it) {
      if (undo) {
        (*it)->undo();
      } else {
        (*it)->redo();
      }
    }
  }


  MUndoManager::UndoSection::UndoSection(const std::string &undoName) {
    MSystemManager::getInstance()->getUndoManager()->beginUndo(undoName);
  }

  MUndoManager::UndoSection::~UndoSection() {
    MSystemManager::getInstance()->getUndoManager()->endUndo();
  }
  

}

