#include "StdAfx.h"

#include <MTransformObject.h>
#include <params/MParameterFactory.h>

#include <params/MTransformMatrixParameter.h>
#include <params/MVector3KeyParameter.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {
  
  //-------------------
  //  MTransformObject
  //-------------------
  
  MTransformObject::MTransformObject() {
    MVector3       Vec;
    
    addParameter(m_Translate = MParameterFactory::createVector3("Tsl", "Translate", "Translate"));
    addParameter(m_Rotate = MParameterFactory::createVector3("Rot", "Rotate", "Rotate"));
    addParameter(m_Scale = MParameterFactory::createVector3("Scl", "Scale", "Scale"));
    addParameter(m_PivotPoint = MParameterFactory::createStaticVector3("piv", "pivot", "Pivot Point"));

    addParameter(MParameterFactory::createStaticVector3("iRot", "initialRotate", "Initial Rotate"));
    
    m_LocalMatrix = new MTransformMatrixParameter(
      "lMat", "localMat", "Local Matrix",
      m_Translate, m_Rotate, m_Scale, m_PivotPoint);

    m_LocalMatrix->setVisible(false);
    m_LocalMatrix->setStorable(false);

    addParameter(m_LocalMatrix);

    setParamByName("Scl", "1 1 1");
    
    setFlag(OBJECTFLAG_NOCOMPONENTS);
  }
  
  MTransformObject::~MTransformObject() {
  }
  
  MBaseObjectPtr MTransformObject::createNew() {
    MTransformObjectPtr NewObj;
    
    NewObj = new MTransformObject;
    NewObj->setFrom(this);
    
    return NewObj;
  }
  
  void MTransformObject::setFrom(MBaseObjectPtr SrcObj) {
    if (SrcObj == NULL) {
      return;
    }
    
    MNamedObject::setFrom(SrcObj);
    
    MTransformObjectPtr Obj;
    
    Obj = AZTEC_CAST(MTransformObject, SrcObj);
    
    if (Obj == NULL) {
      return;
    }
    
    m_PivotPoint = Obj->m_PivotPoint;
  }

  const MVector3 MTransformObject::getTranslateVector(long time) {
    updateObject();
    return m_Translate->getValue();
  }
  
  const MVector3 MTransformObject::getRotateVector(long time) {
    updateObject();
    return m_Rotate->getValue();
  }
  
  const MVector3 MTransformObject::getScaleVector(long time) {
    updateObject();
    return m_Scale->getValue();
  }

  const MVector3 MTransformObject::getPivotPoint() {
    updateObject();
    return m_PivotPoint->getValue();
  }
  

  void MTransformObject::setTranslateVector(const MVector3 &vec) {
    m_Translate->setValueVector(vec);
  }

  void MTransformObject::setRotateVector(const MVector3 &vec) {
    m_Rotate->setValueVector(vec);
  }

  void MTransformObject::setScaleVector(const MVector3 &vec) {
    m_Scale->setValueVector(vec);
  }

  void MTransformObject::setPivotPoint(const MVector3 &vec) {
    m_PivotPoint->setValueVector(vec);
  }

  MVector3ValuePtr getVector3Value(MParameterObjectListPtr list, const MStr &name) {

    MParameterObjectPtr param = list->getParameter(name);

    if (param == NULL) {
      return NULL;
    }

    if (AZTEC_CAST(MVector3KeyParameter, param) != NULL) {
      return AZTEC_CAST(MVector3KeyParameter, param)->getVector3Value();
    }

    if (AZTEC_CAST(MVector3KeyParameter, param->getInputParameter()) != NULL) {
      return AZTEC_CAST(MVector3KeyParameter, param->getInputParameter())->getVector3Value();
    }

    return NULL;

  }

  MVector3ValuePtr MTransformObject::getTranslateKey() {
    updateObject();
    return getVector3Value(m_ParamList, "Tsl");
  }
  
  MVector3ValuePtr MTransformObject::getRotateKey() {
    updateObject();
    return getVector3Value(m_ParamList, "Rot");
  }
  
  MVector3ValuePtr MTransformObject::getScaleKey() {
    updateObject();
    return getVector3Value(m_ParamList, "Scl");
  }
  
  void MTransformObject::getTransformMatrix(MMatrix4 &Matrix) {
    updateObject();

    m_LocalMatrix->getValueMatrix(Matrix);
  }
  
  void MTransformObject::updateKey(int Time, DWORD Channel, bool createKey) {
    if (createKey) {
      MVector3KeyParameter* keyParam = AZTEC_CAST(MVector3KeyParameter, m_Translate);

      if (keyParam != NULL) {
        if ((Channel & TRANSFORM_CHAN_TRANSX) == TRANSFORM_CHAN_TRANSX) {
          keyParam->createXKeyAt(Time);
        }
        if ((Channel & TRANSFORM_CHAN_TRANSY) == TRANSFORM_CHAN_TRANSY) {
          keyParam->createYKeyAt(Time);
        }
        if ((Channel & TRANSFORM_CHAN_TRANSZ) == TRANSFORM_CHAN_TRANSZ) {
          keyParam->createZKeyAt(Time);
        }
      }
      if ((Channel & TRANSFORM_CHAN_TRANSLATE) == TRANSFORM_CHAN_TRANSLATE) {
        m_Translate->createKeyAt(Time);
      }
    
      if (Channel & TRANSFORM_CHAN_ROTATE) {
        m_Rotate->createKeyAt(Time);
      }
    
      if (Channel & TRANSFORM_CHAN_SCALE) {
        m_Scale->createKeyAt(Time);
      }
   
    }
  }
  
  void MTransformObject::holdValues() {
    m_HoldTranslate = m_Translate->getValue();
    m_HoldRotate = m_Rotate->getValue();
    m_HoldScale = m_Scale->getValue();
    m_HoldPivot = m_PivotPoint->getValue();
  }
  
  void MTransformObject::fetchValues() {
    m_Translate->setValueVector(m_HoldTranslate);
    m_Rotate->setValueVector(m_HoldRotate);
    m_Scale->setValueVector(m_HoldScale);
    m_PivotPoint->setValueVector(m_HoldPivot);
  }
  
  bool MTransformObject::doUpdateObject() {
    MNamedObject::doUpdateObject();
    m_Translate->updateObject();
    m_Rotate->updateObject();
    m_Scale->updateObject();
    m_PivotPoint->updateObject();
    return true;
  }

  
}
