#ifndef MChoiceParameter_Header
#define MChoiceParameter_Header

#include "ModelGeneric.h"

namespace Aztec {
  
  class MChoiceParameter;
  typedef MRefCountedPtr<MChoiceParameter> MChoiceParameterPtr;

}

#include <params/MStringParameter.h>
#include <vector>

namespace Aztec {
  

  //---------------------------------------
  //  MChoiceParamter
  //---------------------------------------
  class MGENEXPORT MChoiceParameter : public virtual MStringParameter {
  public:
    /**
     * This returns the index of the current choice.
     */
    virtual int getCurrentChoice() = 0;
    /**
     * This gets the number of choices possible
     */
    virtual int getNumChoices() = 0;
    
    /**
     * This gets the given option.
     */
    virtual MStr getChoice(int index) = 0;
    
    /**
     * This adds the given choice to the list of choices
     */
    virtual void addChoice(const MStr &str) = 0;

  };

  //---------------------------------------
  //  MChoiceParamter
  //---------------------------------------
  class MGENEXPORT MChoiceParameterImpl : public virtual MChoiceParameter,
                                          public MStringParameterImpl {
  public:
    MChoiceParameterImpl(const MStr &shortName = "", const MStr &longName = "", const MStr &friendlyName = "");
    
    // MChoiceParameter methods
    int getCurrentChoice();
    int getNumChoices();
    MStr getChoice(int index);
    void addChoice(const MStr &str);

    // MParamterObject methods
    bool getValueString(MStr &value);
    bool getValueInteger(int &value);

    bool setValueString(const MStr &value);
    bool setValueInteger(int value);

    bool setFromParameter(MParameterObjectPtr src);
    MParameterObjectPtr createCopy();

  protected:
    /**
     * This is the choices that this parameter has.
     */
    std::vector<MStr>  m_Choices;

    /**
     * This is hte current selection of choices.
     */
    int   m_CurrentChoice;
  };

}

#endif
