#ifndef Aztec_Scene_Helper_Header
#define Aztec_Scene_Helper_Header

#include <MScene.h>
#include <MComponentisedObject.h>
#include <MMesh.h>
#include <MEditableMesh.h>

namespace Aztec {

  template <class Type>
  class MSceneHelper {
  public:
    typedef MRefCountedPtr<Type> TypePtr;
    typedef std::pair<MSceneObjectPtr, TypePtr > SceneShapePair;
    typedef std::vector< SceneShapePair > SceneShapeVector;

    static void findObjectsOfType(const MScenePtr &scene, SceneShapeVector &result) {
      g_Scene->getObjectList()->beginIteration();
      MBaseObjectPtr object;
      while ((object = g_Scene->getObjectList()->getNext()) != NULL) {
        MSceneObjectPtr sceneObject = AZTEC_CAST(MSceneObject, object);
        if (sceneObject == NULL) {
          continue;
        }
    
        TypePtr shape = AZTEC_CAST(Type, sceneObject->getShapeObject());
        if (shape != NULL) {
          result.push_back(SceneShapePair(sceneObject, shape));
        }
      }
      g_Scene->getObjectList()->endIteration();
  
    }

    static SceneShapeVector findObjectsOfType(const MScenePtr &scene) {
      SceneShapeVector result;
      findObjectsOfType(scene, result);
      return result;
    }

  };

  template <class T>
  inline MComponentisedObjectPtr getComponentObject(const MRefCountedPtr<T> &obj) {
    MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, obj);
    return getComponentObject(sceneObj);
  }
  
  inline MComponentisedObjectPtr getComponentObject(const MSceneObjectPtr &obj) {
    if (obj != NULL) {
      return obj->getComponentObject();
    } else {
      return NULL;
    }
  }

  template <class T>
  inline MMeshPtr getMeshObject(const MRefCountedPtr<T> &obj) {

    MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, obj);
    MShapeObjectPtr shape;

    if (sceneObj != NULL) {
      shape = sceneObj->getShapeObject();
    } else {
      shape = AZTEC_CAST(MShapeObject, obj);
    }

    if (shape != NULL) {
      return AZTEC_CAST(MMesh, shape->convertToMesh());
    } else {
      return AZTEC_CAST(MMesh, obj);
    }

  }

  template <class T>
  inline MEditableMeshPtr getEditableMeshObject(const MRefCountedPtr<T> &obj) {

    MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, obj);

    if (sceneObj != NULL) {
      return AZTEC_CAST(MEditableMesh, sceneObj->getEditableComponentObject());
    } else {
      return AZTEC_CAST(MEditableMesh, obj);
    }

  }


}

#endif