#ifndef REGISTRYCLASS_H
#define REGISTRYCLASS_H

#include "ModelGeneric.h"
#include "MStr.h"
// The aim of this class is to encapsulate registry functions into one class
// aint with having a ltitle more flexibility and useability.


#include <MBasicTypes.h>

#include <string>

#ifndef WIN32

typedef void* HKEY;
typedef DWORD REGSAM;

#define KEY_READ 1
#define KEY_WRITE 2

#define REG_NONE    ((char*)0)

#endif

#ifdef WIN32
#define REGCLASS_USE_REGISTRY
#endif

#ifndef REGCLASS_USE_REGISTRY
#include <IniFile.h>
#endif

namespace Aztec {

  class MGENEXPORT MRegistry
  {
  #ifdef REGCLASS_USE_REGISTRY
	  HKEY		m_hRootKey;
	  HKEY		m_hCurrentKey;
  #else
    std::string m_RootKey;

    CIniFile iniFile;

    bool changesMade;

  #endif

    std::string m_CurrentKeyStr;
    std::string m_KeyPrefix;
    std::string m_KeySuffix;

  public:
    static const std::string CURRENT_USER;
  
    MRegistry();
	  virtual ~MRegistry();

    void setRootKey(const std::string &key);
	  void setKeyPrefix(char *Prefix);
	  void setKeySuffix(char *Suffix);

	  int openKey(char *Key, REGSAM Access = KEY_READ | KEY_WRITE, bool AutoCreate = true);
	  int closeKey();	// Closes the current key
	  int writeString(const char *Name, const char *Data);
	  int writeDWORD(const char *Name, DWORD Data);
	  int writeBinary(const char *Name, BYTE *Data, int Size);
	  MStr readString(const char *Name);
    int readString(const char *Name, MStr &Data);
    int readString(const char *Name, char *Data);
	  int readDWORD(const char *Name, DWORD &Data);
	  int readBinary(const char *Name, BYTE *Data, int MaxSize);

  };

}
#endif // !defined(AFX_REGISTRY_H__AE6460F4_539A_11D2_A01D_0040332C7B2F__INCLUDED_)
