#include <AztecGUICommonPCH.h>

#include <gui/win32/MTabbedContainerImpl.h>
#include <gui/win32/MContainerImpl.h>
#include <gui/win32/MAppImpl.h>
#include <config/UIConfig.h>

#include <assert.h>

namespace Aztec {

  MTabbedContainer::MTabbedContainer()
  {
  }

  MTabbedContainer::~MTabbedContainer() {
  }

  bool MTabbedContainer::createImpl() {
    MApp *app;
    HWND parentHWND = NULL;

    // Get the parent windows hwnd, so we can create our button.
    if (m_Parent != NULL) {
      parentHWND = m_Parent->getHWnd();
    }

    app = MApp::getInstance();

    // create the actual windows control.

    m_hWnd = ::CreateWindowEx(0, WC_TABCONTROL, "Tabbed", WS_CHILD ,
                              0, 10, 0, 10, parentHWND, NULL, app->getHInstance(), NULL);

    // if it succeeded, update everything.
    if (m_hWnd != 0) {

      // Register this control and hwnd with the application.
      app->registerComponent(m_hWnd, this);

      // Change the font of the button.
      ::SendMessage(m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

      // Call the crete event handler.
      onCreate();

      // show the button, and update the screen.
      setVisible(true);
      ::UpdateWindow(m_hWnd);

      return true;
    }

    return false;
  }

  MContainerPtr MTabbedContainer::addPane(const std::string &label) {
    MContainerPtr child = new MContainer();
    addComponent(child);

    panes.push_back(child);

    TCITEM item;
    item.mask = TCIF_TEXT;
    item.pszText = const_cast<char*>(label.c_str());
    TabCtrl_InsertItem(m_hWnd, getPaneCount(), &item);

    return child;
  }

  int MTabbedContainer::getPaneCount() const {
    return TabCtrl_GetItemCount(m_hWnd);
  }

  int MTabbedContainer::getCurrentPane() const {
    return TabCtrl_GetCurSel(m_hWnd);
  }

  void MTabbedContainer::doLayout() {
    // find the active tab, show it, hide the others, and resize it to our biggest size.
    int current = getCurrentPane();

    // if the current pane is -1, then we just use the first one.
    if (current < 0) {
      current = 0;
    }

    RECT rect;
      
    ::GetClientRect(m_hWnd, &rect);
    TabCtrl_AdjustRect(m_hWnd, FALSE, &rect);

    for (int i = 0; i < panes.size(); ++i) {
      panes[i]->setVisible(false);
    }
    for (int i = 0; i < panes.size(); ++i) {
      if (i == current) {
        panes[i]->setPosition(rect.left, rect.top, rect.right-rect.left, rect.bottom-rect.top);
        panes[i]->doLayout();
        panes[i]->setVisible(true);
      }
    }

  }

  bool MTabbedContainer::handleWMNotify(WPARAM wParam, LPARAM lParam) {
    NMHDR *notify = (NMHDR*)lParam;
    if (notify->code == TCN_SELCHANGE) {
      doLayout();
      return true;
    }
    return MContainer::handleWMNotify(wParam, lParam);
  }

  MSize2D MTabbedContainer::getMinimumSize() {
    MSize2D size(0,0);

    for (int i = 0; i < panes.size(); ++i) {
      size = MRect2D::getLargest(size, panes[i]->getMinimumSize());
    }

    // now adjust the rectangle to fit in the tab control header.
    RECT r;
    r.left = 0;
    r.top = 0;
    r.bottom = size.getHeight();
    r.right = size.getWidth();

    TabCtrl_AdjustRect(m_hWnd, TRUE, &r);


    return MSize2D(r.right - r.left,r.bottom - r.top);

  }

  bool MTabbedContainer::isMinimumSizeSet() {
    return true;
  }

}

