#include <AztecGUICommonPCH.h>
#include <gui/MFileDialog.h>
#include <gui/MApplication.h>

namespace Aztec {
  MFileDialog::MFileDialog() {
    selectedFilter = ALL_KNOWN_FILES;
    strcpy(filenameBuffer, "");

  }

  // MFileDialog methods
  void MFileDialog::setFilename(const std::string &filename) {
    this->filename = filename;
  }

  void MFileDialog::setPath(const std::string &path) {
    this->path = path;
  }

  void MFileDialog::addFilter(const std::string &description, const std::string &filter) {
    filters.push_back(FilterPair(description, filter));
  }

  void MFileDialog::setFilter(int index) {
    selectedFilter = index;
  }

  bool MFileDialog::doModal() {
    setupOFN(ofn);

    BOOL result = showDialog(ofn);

    // now extract out the various bits of information.
    if (result != 0) {
      // if we have a special filtr, handle it specially
      if (ofn.nFilterIndex != 0) {
        int index = ofn.nFilterIndex - 1;
        if (index >= filters.size()) {
          selectedFilter = ((int)filters.size()) - index - 1;
        } else {
          selectedFilter = index;
        }
      } else {
        // we have a custom filter, so go through the filters to see if we have a match
        std::string customFilter = ofn.lpstrCustomFilter;

        selectedFilter = -1;
        for (int i = 0; i < filters.size(); ++i) {
          if (filters[i].second.find(customFilter) != std::string::npos) {
            selectedFilter = i;
            break;
          }
        }

      }

      extractFilename(ofn);

      return true;
    } else {
      DWORD err =  CommDlgExtendedError() ;
      if (err != 0) {
        OutputDebugString("File Dialog Box Error!\n");
      }

      return false;
    }
  }

  std::string MFileDialog::getFilename() {
    // The absolute filename is stored in the path and filename variables.
    if (path.find_last_of('\\') + 1 == path.length()) {
      return path + filename;
    } else {
      return path + "\\" + filename;
    }
  }

  int MFileDialog::getFilter() {
    return selectedFilter;
  }

  void MFileDialog::setTitle(const std::string &title) {
    this->title = title;
  }

  void MFileDialog::setupOFN(OPENFILENAME &ofn) {

    int filterCount = getWindowsFilters(ofnFilters);

    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = MApp::getInstance()->getTopLevelWindow()->getHWnd(); // TODO: Must change to a valid value.
    ofn.hInstance = MApp::getInstance()->getHInstance();
    ofn.lpstrFilter = ofnFilters.c_str();
    ofn.lpstrCustomFilter = NULL;//userFilter;
    ofn.nMaxCustFilter = 0;//USER_FILTER_SIZE;

    // do something special based wether we got a special filter or not
    // An index of >= 0 means we have an explicit filter, less than zero
    // means a special filter like ALL_KNOWN_FILES.

    // We only allow use of the special filters if the generated filters 
    // exceeds the number of stored filters.
    if (selectedFilter < 0) {
      if (filterCount > filters.size()) {
        ofn.nFilterIndex = filters.size() + abs(selectedFilter);
      } else {
        ofn.nFilterIndex = 1;
      }
    } else {
      // The windows filter index is 1 based.
      ofn.nFilterIndex = selectedFilter + 1;
    }

    strcpy(filenameBuffer, filename.c_str());
    ofn.lpstrFile = filenameBuffer;
    ofn.nMaxFile = FILENAME_BUFFER_SIZE;
    
    ofn.lpstrFileTitle = NULL;
    ofn.nMaxFileTitle = 0;


    ofn.lpstrInitialDir = path.length() == 0 ? NULL : path.c_str();

    ofn.lpstrTitle = title.c_str();
    ofn.Flags = OFN_PATHMUSTEXIST;

    ofn.nFileOffset = 0;
    ofn.nFileExtension = 0;
    ofn.lpstrDefExt = NULL;
    ofn.lCustData = 0;
    ofn.lpfnHook = 0;
    ofn.lpTemplateName = 0;
  }

}

