#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MWindow.h>

namespace Aztec {


  JSBool js_MWindow_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    
    std::string title = "Window";

    if (argc >= 1) {
      title = JS_GetStringBytes(JS_ValueToString(cx, argv[0]));
    }

    MWindowPtr newComponent = new MWindow(title);
    newComponent->create();
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }

  static JSBool js_MWindow_getTitle(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MWindowPtr window = getGuiObject<MWindow>(cx, obj);

    if (window != NULL) {
      *rval = STRING_TO_JSVAL( JS_NewStringCopyZ(cx, window->getTitle().c_str()) );
      return JS_TRUE;
    } else {
      JS_ReportError(cx, "Could not find the MWindowPtr for this js object.");
      return JS_FALSE;
    }
  }
  
  static JSBool js_MWindow_setTitle(JSContext *cx, JSObject *obj, jsval id, jsval *js_value) {
    MWindowPtr window = getGuiObject<MWindow>(cx, obj);

    if (window != NULL) {
      window->setTitle(JS_GetStringBytes( JS_ValueToString(cx, *js_value)));
      return JS_TRUE;
    } else {
      JS_ReportError(cx, "Could not find the MWindowPtr for this js object.");
      return JS_FALSE;
    }
  }

  static JSPropertySpec js_MWindow_props[] = {
    {"title", 0, JSPROP_ENUMERATE, js_MWindow_getTitle, js_MWindow_setTitle }, 
    {0, 0, 0, 0}
  };
 
  
  JSClass js_MWindow_class = {
    "MWindow", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMWindow_methods[] = {
    // Object/mesh creation
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMWindowClass(JSContext *cx, JSObject *containerClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), containerClass,
      &js_MWindow_class, js_MWindow_constructor, 0,
      NULL, aztecMWindow_methods, 0, 0);
    
    JS_DefineProperties(cx, cl, js_MWindow_props);

    return cl;
    
  }
}
