#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MTabbedContainer.h>
namespace Aztec {

  static JSBool js_addPane(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  JSBool js_MTabbedContainer_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    return js_generic_constructor(cx, obj, new MTabbedContainer());
  }

  JSClass js_MTabbedContainer_class = {
    "MTabbedContainer", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMTabbedContainer_methods[] = {
    // Object/mesh creation
    {"addPane",      js_addPane,        1},
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMTabbedContainerClass(JSContext *cx, JSObject *componentClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), componentClass,
      &js_MTabbedContainer_class, js_MTabbedContainer_constructor, 0,
      NULL, aztecMTabbedContainer_methods, 0, 0);
    
    return cl;
    
  }
  
  
  static JSBool js_addPane(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
  		JS_ReportError(cx, "MTabbedContainer.addPane() requires one argument");
      return JS_FALSE;
    }
    
    std::string text = JS_GetStringBytes( JS_ValueToString(cx, argv[0]) );

    MTabbedContainerPtr tabbed = getGuiObject<MTabbedContainer>(cx, obj);
    MContainerPtr container;
    
    container = tabbed->addPane(text);
    if (container != NULL) {
      JSObject *jsContainer = getJSObject(cx, NULL, container);
      *rval = OBJECT_TO_JSVAL(jsContainer);

      return JS_TRUE;
    } else {
  		JS_ReportError(cx, "MTabbedContainer.addPane() failed, and returned a null container.");
      return JS_FALSE;
    }
  }
 
  

}
