#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MSlider.h>
namespace Aztec {

  static JSBool js_MSlider_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_method_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_prop_getValue(JSContext *cx, JSObject *obj, jsval id, jsval *rval);
  static JSBool js_getValue(JSContext *cx, JSObject *obj, jsval *rval);
  static JSBool js_method_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_prop_setValue(JSContext *cx, JSObject *obj, jsval id, jsval *js_value);
  static JSBool js_setValue(JSContext *cx, JSObject *obj, jsval js_value);
  static JSBool js_getMax(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_setMax(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_getMin(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_setMin(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_addSliderListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  JSClass js_MSlider_class = {
    "MSlider", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMSlider_methods[] = {
    // Object/mesh creation
    {"getValue",  js_method_getValue,          0},
    {"setValue",  js_method_setValue,          1},
    {"getMin",  js_getMin,          0},
    {"setMin",  js_setMin,          1},
    {"getMax",  js_getMax,          0},
    {"setMax",  js_setMax,          1},
    {"addListener",    js_addSliderListener,    1},
    {NULL,                NULL,                   0} 
  };
  
  static JSPropertySpec js_MSlider_props[] = {
    {"value", 0, JSPROP_ENUMERATE, js_prop_getValue, js_prop_setValue}, 
    {0, 0, 0, 0}
  };


  JSObject* initMSliderClass(JSContext *cx, JSObject *componentClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), componentClass,
      &js_MSlider_class, js_MSlider_constructor, 0,
      NULL, aztecMSlider_methods, 0, 0);
    
    JS_DefineProperties(cx, cl, js_MSlider_props);

    return cl;
    
  }
  
  static JSBool js_MSlider_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {

    // we only accept 0,1, 2, or 3 arguments
    if (argc > 3) {
      return JS_FALSE;
    }

    long min = 0;
    long max = 100;
    long pos = 0;

    if (argc >= 1) {
      JS_ValueToInt32(cx, argv[0], &min);
    }
    if (argc >= 2) {
      JS_ValueToInt32(cx, argv[1], &max);
    }
    if (argc >= 3) {
      JS_ValueToInt32(cx, argv[2], &pos);
    }

    MSliderPtr newComponent = new MSlider(min, max, pos);
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }

  static JSBool js_method_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      return JS_FALSE;
    }

    return js_getValue(cx, obj, rval);
  }

  static JSBool js_prop_getValue(JSContext *cx, JSObject *obj, jsval id, jsval *rval)
  {
    return js_getValue(cx, obj, rval);
  }

  static JSBool js_getValue(JSContext *cx, JSObject *obj, jsval *rval)
  {
    MSliderPtr slider = getGuiObject<MSlider>(cx, obj);
    
    if (slider != NULL) {
      *rval = INT_TO_JSVAL( slider->getValue() );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_method_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc != 1) {
      return JS_FALSE;
    }
    
    return js_setValue(cx, obj, argv[0]);
  }

  static JSBool js_prop_setValue(JSContext *cx, JSObject *obj, jsval id, jsval *js_value) {
    return js_setValue(cx, obj, *js_value);
  }
  
  static JSBool js_setValue(JSContext *cx, JSObject *obj, jsval js_value)
  {
    MSliderPtr slider = getGuiObject<MSlider>(cx, obj);
    
    if (slider != NULL) {
      long value = 0;
      JS_ValueToInt32(cx, js_value, &value);
      slider->setValue( value );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }
    

  static JSBool js_getMin(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      return JS_FALSE;
    }

    MSliderPtr slider = getGuiObject<MSlider>(cx, obj);
    
    if (slider != NULL) {
      *rval = INT_TO_JSVAL(slider->getMinimum());
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }
  
  static JSBool js_setMin(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      return JS_FALSE;
    }
    
    MSliderPtr slider = getGuiObject<MSlider>(cx, obj);
    
    if (slider != NULL) {
      long value = 0;
      JS_ValueToInt32(cx, argv[0], &value);
      slider->setMinimum(value);
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }

  static JSBool js_getMax(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      return JS_FALSE;
    }

    MSliderPtr slider = getGuiObject<MSlider>(cx, obj);
    
    if (slider != NULL) {
      *rval = INT_TO_JSVAL(slider->getMaximum());
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }
  
  static JSBool js_setMax(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      return JS_FALSE;
    }
    
    MSliderPtr slider = getGuiObject<MSlider>(cx, obj);
    
    if (slider != NULL) {
      long value = 0;
      JS_ValueToInt32(cx, argv[0], &value);
      slider->setMaximum(value);
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }

  class JS_SliderChangeListener : public MSlider::SliderListener {
  public:
    JS_SliderChangeListener(JSContext *cx, JSObject *obj, JSFunction *function, uintN argc, jsval *argv) {
      this->cx = cx;
      this->func = function;
      this->object = obj;
      for (uintN i = 0; i < argc; ++i) {
        args.push_back(argv[i]);
      }
    }

    void onChange(const MSliderPtr &slider) {

      jsval rval;

      jsval *argv = new jsval[args.size()];

      for (unsigned i = 0; i < args.size(); ++i) {
        argv[i] = args[i];
      }

      JS_CallFunction(cx, object, func, args.size(), argv, &rval);

      delete[] argv;
    }

    JSContext *cx;
    JSFunction *func;
    JSObject *object;
    std::vector<jsval> args;
  };

  static JSBool js_addSliderListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc < 1) {
      return JS_FALSE;
    }

    MSliderPtr slider = getGuiObject<MSlider>(cx, obj);
    JSFunction *func = JS_ValueToFunction(cx, argv[0]);
    
    if (func != NULL && slider != NULL) {

      slider->addListener(new JS_SliderChangeListener(cx, obj, func, argc - 1, argv + 1));

      return JS_TRUE;
    } else {
      return JS_FALSE;
    }


    return JS_FALSE;
  }


}
