#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MBorderLayout.h>

namespace Aztec {
  JSBool js_MBorderLayout_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    // we only accept 0, or 2 arguments to a constructor.
    // with zero, args, we do a default border width. 2 args we have a border width and height.

    bool borderKnown = false;
    int borderWidth = -1, borderHeight = -1;

    if (argc != 0) {
      if (argc == 2) {
        if (JSVAL_IS_INT(argv[0]) && JSVAL_IS_INT(argv[1])) {
          borderKnown = true;
          borderWidth = JSVAL_TO_INT(argv[0]);
          borderHeight = JSVAL_TO_INT(argv[1]);
        }
      }
    }

    MLayoutManagerPtr layout;
    
    if (borderKnown) {
      layout = new MBorderLayout(borderWidth, borderHeight);
    } else {
      layout = new MBorderLayout();
    }
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(layout));
  }
  
  JSClass js_MBorderLayout_class = {
    "MBorderLayout", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  
  static JSFunctionSpec aztecMBorderLayout_methods[] = {
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMBorderLayoutClass(JSContext *cx) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), NULL,
      &js_MBorderLayout_class, js_MBorderLayout_constructor, 0,
      NULL, aztecMBorderLayout_methods, 0, 0);
    JSObject *con = JS_GetConstructor(cx, cl);
    
    if (con != NULL) {
      JS_DefineProperty(cx, con, "NORTH", INT_TO_JSVAL(MBorderLayout::NORTH), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "SOUTH", INT_TO_JSVAL(MBorderLayout::SOUTH), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "NORTH_INNER", INT_TO_JSVAL(MBorderLayout::NORTH_INNER), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "SOUTH_INNER", INT_TO_JSVAL(MBorderLayout::SOUTH_INNER), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "EAST", INT_TO_JSVAL(MBorderLayout::EAST), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "WEST", INT_TO_JSVAL(MBorderLayout::WEST), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "CENTRE", INT_TO_JSVAL(MBorderLayout::CENTRE), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
    }

    return cl;
  }


}
