/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>
#include <gui/MOpenFileDialog.h>


namespace Aztec {
  MOpenFileDialog::MOpenFileDialog() {
    multipleSelect = false;
  }

  void MOpenFileDialog::setMultipleSelect(bool multipleSelect) {
    this->multipleSelect = multipleSelect;
  }

  void MOpenFileDialog::getFilenames(std::vector<std::string> &filenames) {
    filenames = this->filenames;
  }

  bool MOpenFileDialog::showDialog(QFileDialog* fdialog) {
    // Set bits of information
    // TODO: Do the right thing
    fdialog->setFilters(QString("3D Studio (*.3ds);;" \
                        "Lightwave (*.lwo);;" \
                        "Maya (*.obj);;" \
                        "RenderMan (*.rib);;" \
                        "Nendo (*.ndo);;" \
                        "POV-Ray (*.pov)"));
    fdialog->setMode(QFileDialog::ExistingFile);

    // TODO: Set $HOME dir?
    fdialog->setDir("/home");

    return (fdialog->exec() == QDialog::Accepted);
  }


}

