/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  2111-1307  USA

*/

#include <AztecGUICommonPCH.h>
#include <iostream>

#include <gui/qt3/MMenuImpl.h>
#include <gui/qt3/QPopupMenu_.moc>

#include <gui/MMenuBar.h>


/**
 * Hide this away, should never be used outside.
 * This is also a nice way to keep the class views
 * in IDE's a bit more clean ;)
 */
namespace NS_hidden {

  typedef std::vector<Aztec::MMenu*> nsMenuMap;
  nsMenuMap g_mmap;

  /**
   * Registers a menu item so it won't get lost by
   * the 'smart' pointer code (comment out the body
   * of this function and try to run Aztec to see
   * what I mean.. *crash*).
   */
  void registerMenu(Aztec::MMenu* item) {
    //g_mmap[item->getID()] = item;
    g_mmap.push_back(item);
  };

  void unregisterMenu(Aztec::MMenu* item) {
    //g_mmap.erase(item->getID());
    nsMenuMap::iterator it;
    for (it=g_mmap.begin(); it!=g_mmap.end(); ++it) {
      if ((*it) == item) g_mmap.erase(it);
    }
  };
}



namespace Aztec {

  MMenu::MMenu()
    : m_indexID(-1) {

    m_MenuHandle = 0l;

    init();
    NS_hidden::registerMenu(this);
  }

  MMenu::~MMenu() {
    m_Items.clear();

    // destroy the Qt menu
    if (m_MenuHandle) {
      delete m_MenuHandle;
      m_MenuHandle = 0l;
    }

    NS_hidden::unregisterMenu(this);
  }

  bool MMenu::init() {
    if (m_MenuHandle != 0l) return true;
    MApp* app = MApp::getInstance();

    m_MenuHandle = new CQPopupMenu_(this);
    if (m_MenuHandle != 0) return true;

    return false;
  }

  int MMenu::getItemCount() {
    return m_Items.size();
  }

  MMenuItemPtr MMenu::getItem(int index) {
    return m_Items[index];
  }

  void MMenu::addItem(MMenuItemPtr item) {
    int index = 0;

    if (item->getSubMenu() != 0l) {
      // getSubMenu will always return MMenu's so there's no
      // need to check if the upcast failed.
      item->getSubMenu()->init();
      QPopupMenu* m = dynamic_cast<QPopupMenu*>(item->getSubMenu()->m_MenuHandle);

      index = m_MenuHandle->insertItem(item->getCaption().c_str(), m);
    }
    else {
      if (m_MenuHandle != 0l) {
        index = m_MenuHandle->insertItem(item->getCaption().c_str());
      }
    }

    // ..do some setup magic
    item->setParent(this);
    item->setID(index);
    item->createImpl();

    // ..and add the item to our internal list
    m_Items.insert(std::map<int, MMenuItemPtr>::value_type(index, item));
  }

  void MMenu::addItem(MMenuItemPtr item, int index) {
    // TODO: Use the index argument
std::cout << "addItem(item, index)" << std::endl;
    int idx = 0;

    if (item->getSubMenu() != 0l) {
      // getSubMenu will always return MMenu's so there's no
      // need to check if the upcast failed.
      item->getSubMenu()->init();
      QPopupMenu* m = dynamic_cast<QPopupMenu*>(item->getSubMenu()->m_MenuHandle);

      idx = m_MenuHandle->insertItem(item->getCaption().c_str(), m);
    }
    else {
      if (m_MenuHandle != 0l) {
        idx = m_MenuHandle->insertItem(item->getCaption().c_str());
      }
    }

    // ..do some setup magic
    item->setParent(this);
    item->setID(idx);
    item->createImpl();

    // ..and add the item to our internal list
    m_Items.insert(std::map<int, MMenuItemPtr>::value_type(idx, item));
  }

  void MMenu::addSeparator() {
    // TODO: index
    addSeparator(0);
  }

  void MMenu::addSeparator(int index) {
    // TODO: Use index arg
    if (m_MenuHandle != 0l) {
      m_MenuHandle->insertSeparator();
    }
  }

  void MMenu::removeItem(int index) {
    // TODO: Implementation
  }

  bool MMenu::onItemClick(const MMenuItemPtr &item) {
    // Don't handle the message by default, so just return false.
    return false;
  }

  bool MMenu::popupMenu(const MComponentPtr &component, const MPoint2D &position) {
    QPopupMenu* pmenu = dynamic_cast<QPopupMenu*>(m_MenuHandle);

    // Adjust the position so it's in screen space
    QPoint point = QPoint(position.x, position.y);
    point = component->getHandle()->mapToGlobal(point);

    // Pop up the menu
    int result = pmenu->exec(point, -1);
    if (result != -1) {
      // TODO: Implementation
    }

    return true;
  }

}

