#include <AztecGUICommonPCH.h>

#include <config/ColourConstants.h>

#include <map>

namespace AztecGUI {


  typedef std::map<Colours::Colour, std::string> ColourNameMap;
  typedef std::map<std::string, Colours::Colour> NameColourMap;

  static ColourNameMap colourNameMap;
  static NameColourMap nameColourMap;

  static void addColour(Colours::Colour col, const char *name) {
    colourNameMap[col] = name;
    nameColourMap[name] = col;
  }

  static void initColours() {
    if (colourNameMap.size() != 0) {
      return;
    }

    addColour(Colours::VIEW_BACKGROUND, "VIEW_BACKGROUND");
    addColour(Colours::VIEW_TITLE, "VIEW_TITLE");
    addColour(Colours::VIEW_TITLE_CURRENT, "VIEW_TITLE_CURRENT");
    addColour(Colours::VIEW_BORDER, "VIEW_BORDER");
    addColour(Colours::VIEW_BORDER_CURRENT, "VIEW_BORDER_CURRENT");

    addColour(Colours::GRID3D_MAJOR, "GRID3D_MAJOR");
    addColour(Colours::GRID3D_MINOR, "GRID3D_MINOR");
	addColour(Colours::GRID3D_AXIS, "GRID3D_AXIS");

    addColour(Colours::OBJECT_WIREFRAME, "OBJECT_WIREFRAME");
    addColour(Colours::OBJECT_WIREFRAME_SELECTED, "OBJECT_WIREFRAME_SELECTED");

    addColour(Colours::X_AXIS, "X_AXIS");
    addColour(Colours::Y_AXIS, "Y_AXIS");
    addColour(Colours::Z_AXIS, "Z_AXIS");
    addColour(Colours::SELECTED_AXIS, "SELECTED_AXIS");

    addColour(Colours::TIMESLIDER_BACKGROUND, "TIMESLIDER_BACKGROUND");
    addColour(Colours::TIMESLIDER_TICKMARKS, "TIMESLIDER_TICKMARKS");
    addColour(Colours::TIMESLIDER_TEXT, "TIMESLIDER_TEXT");
    addColour(Colours::TIMESLIDER_CURRENT_FRAME, "TIMESLIDER_CURRENT_FRAME");
    addColour(Colours::TIMESLIDER_KEY_FRAME, "TIMESLIDER_KEY_FRAME");

    addColour(Colours::GRAPH_PLOT_LINE, "GRAPH_PLOT_LINE");
    addColour(Colours::GRAPH_KEY, "GRAPH_KEY");
    addColour(Colours::GRAPH_KEY_SELECTED, "GRAPH_KEY_SELECTED");


  }

  const char* Colours::getName(Colours::Colour colour) {
    initColours();
    return colourNameMap[colour].c_str();
  }

  Colours::Colour Colours::getColourIndex(const std::string &name) {
    initColours();
    return nameColourMap[name];
  }

}



