#ifndef MTabbedContainerImpl_Header
#define MTabbedContainerImpl_Header

#include <gui/MTabbedContainer.h>
#include <gui/win32/MContainerImpl.h>
#include <gui/win32/MDIBImage.h>

#include <string>

#include <windows.h>

namespace Aztec {

  class AZTECGUI_EXPORT MTabbedContainer : public virtual Aztec::IMTabbedContainer, public MContainer {
  public:
    /**
     * Constructs a button with the given caption, command and preferred size.
     */
    MTabbedContainer();
    ~MTabbedContainer();

    /**
     * This creates the implementation window
     */
    virtual bool createImpl();

    WNDPROC lpfnOldWndProc;

    // MTabbedContainer methods
    MContainerPtr addPane(const std::string &label);
    int getPaneCount() const;
    int getCurrentPane() const;

    // MContainer methods
    void doLayout();

    // MComponent methods
    bool handleWMNotify(WPARAM wParam, LPARAM lParam);

    // IMComponent methods
    MSize2D getMinimumSize();
    bool isMinimumSizeSet();
  
  protected:
    std::vector<MContainerPtr> panes;
  };

}


#endif