#ifndef MGLCanvasImpl_Header
#define MGLCanvasImpl_Header

#include <gui/MGLCanvas.h>

#include <gl/gl.h>

namespace Aztec {

  class AZTECGUI_EXPORT MGLCanvas : public virtual Aztec::IMGLCanvas, public MComponent {
  public:
    
    MGLCanvas();
    ~MGLCanvas();

    GLErrorEnum initOpenGL();
    GLErrorEnum killOpenGL();

    // IMGLCanvas methods
    GLErrorEnum makeCurrent();
    bool swapBuffers();

    // MComponent methods
    bool createImpl();

    // IMComponent methods
    bool onResize(int newWidth, int newHeight);
    bool onPaint();

  protected:
    HGLRC glContext;
    bool sizeChanged;
    int newx, newy;

    GLErrorEnum makeCurrent(HDC dc);
    bool swapBuffers(HDC dc);
  };

}


#ifdef _WIN32
#include <gui/win32/MGLCanvasImpl.h>
#endif


#endif
