#ifndef Aztec_GUI_MDIBImage_Header
#define Aztec_GUI_MDIBImage_Header

#include <AztecGUICommon.h>

#include <MImages.h>

#include <windows.h>


namespace Aztec {

  
  /**
   * this class provides a simple ecapsulation of Device independant bitmaps, 
   * and a simple mechanism for loading them from .bmp files. This is intended
   * primarily for button drawing and similar tasks
   */
  class AZTECGUI_EXPORT MDIBImage {
  public:
    BITMAPINFOHEADER m_BitmapInfoHeader;
    /// A complete header, consiting of both palette and header
    BYTE *m_CompleteHeader;   
    /// Palette of image, if requred.
    RGBQUAD *m_Palette;
    /// Actual Pixel data
    BYTE *m_Pixels;
    /// Handle to the bitmap
    HBITMAP m_hBitmap;
    
    int m_Width, m_Height, m_Depth;

    /// the number of bytes in each row. This is (m_Width * m_BitmapInfoHeader.biBitCount / 8) rounded to the nearest 4 bytes.
    int m_DataWidth;
    
    MDIBImage();
    virtual ~MDIBImage();
    
    int CreateEmptyBitmap(HDC hDC, int Width, int Height, int Depth, RGBQUAD *SrcPalette = NULL);
    int SetFromBitmap(const MDIBImage &Bmp, HDC hDC = NULL);
    void DeleteBitmap();
    void setFromImage(const Aztec::MImagePtr &newImage, HDC hDC);
    
    int Draw(HDC hDC, int x, int y, int w=-1, int h=-1);
    int Draw(HDC hDC, int destx, int desty, int srcx, int srcy, int w, int h);
    
    int LoadFromBMP(const char *Filename, HDC hDC = NULL);
  };


}
#endif