#ifndef Aztec_GUICommon_MSlider_Header
#define Aztec_GUICommon_MSlider_Header

#include <MRefCountedPtr.h>

namespace Aztec {

  class IMSlider;
  class MSlider;

  typedef MRefCountedPtr<IMSlider> IMSliderPtr;
  typedef MRefCountedPtr<MSlider> MSliderPtr;

}

#include <gui/MComponent.h>

#include <string>


namespace Aztec {

  /**
   */
  class AZTECGUI_EXPORT IMSlider : public virtual IMComponent {
  protected:
    IMSlider() { }
    ~IMSlider() { }

  public:
    class SliderListener : public MRefCountedObject {
    public:
      virtual void onChange(const MSliderPtr &slider) = 0;
    };

    typedef MRefCountedPtr<SliderListener> SliderListenerPtr;

    virtual void setValue(int value) = 0;
    virtual int getValue() = 0;

    virtual void setRange(int min, int max) = 0;
    virtual void setMinimum(int min) = 0;
    virtual void setMaximum(int max) = 0;
    virtual int getMinimum() = 0;
    virtual int getMaximum() = 0;

    /**
     * This is called after the slider has been moved.
     */
    virtual bool onChanged() = 0;

    virtual void addListener(const SliderListenerPtr &listener) = 0;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MSliderImpl.h>


#endif

