#ifndef MFlowLayout_Header
#define MFlowLayout_Header

#include <gui/MLayoutManager.h>
#include <gui/MSize2D.h>

#include <string>
#include <vector>

namespace Aztec {

  class AZTECGUI_EXPORT MFlowLayout : public virtual MLayoutManager {

  public:

    MFlowLayout(int horizGap = 2, int vertGap = 2, int maxComponentsPerRow = -1);

    ~MFlowLayout();

    // Layoutmanager methods
    void addComponent(MComponentPtr component);

    void addComponent(MComponentPtr component, MConstraint constraints);

    void removeComponent(MComponentPtr component);

    void layoutContainer(MContainerPtr container);

    /**
     * This gets the minimum size of this layout. The 
     * minimum size of a flow layout is the largest minimum
     * of all the components, plus the horizontal and vertical
     * gaps.
     */
    MSize2D getMinimumSize(MContainerPtr container);

    /**
     * This gets the minimum size of this layout. The 
     * preferred size of a flow layout total of the preferred
     * widths of all the components, plus a gap in between
     * each.
     */
    MSize2D getPreferredSize(MContainerPtr container);

    MConstraint getConstraint(const MComponentPtr &component);

  protected:
    int m_VGap, m_HGap;
    int m_maxComponentsPerRow;

  };

}


#endif

