#ifndef Aztec2_UIConfig_Header
#define Aztec2_UIConfig_Header

#include <config/ColourConstants.h>
#include <gui/MShiftState.h>
#include <tools/MToolType.h>

#include <MMath.h>

#include <map>

namespace AztecGUI {

  class AZTECGUI_EXPORT UIConfig {
  public:
    /// This sets up any scripting hooks, and what ever else it needs to do.
    static void initialise();

    /// Loads any configuration data
    static void loadConfig();

    /// Saves the current config data to a user specific config file somewhere.
    static void saveConfig();

    static std::string getQuickToolFor(const std::string &viewGroup, const Aztec::MShiftState &shiftState);

    static bool isGrabManipulator(const Aztec::MShiftState &shiftState);
    /**
     * This checks to see if any changes have been made to user editable 
     * things that need saving. This is checked when we quit, or want to open 
     * a new file, to see if we need to pop up a confirmation fialog or not.
     *
     * @return true True if changes have been made, false if they haven't.
     */
    static bool changesMade();

    /**
     * This sets wether or not something has changed in the system. 
     *
     * @param changed True if changes have been made, false if they haven't.
     */
    static void setChanged(bool changed);

    /**
     * This gets the filename of the scene we are currently editing. This is 
     * used for a number of things, including setting the main title bar to an
     * appropriate name, and using the correct filename when doing a file->save.
     *
     * @return The filename of the file we are currently editing, "" if no 
     *         filename has been specified.
     */
    static std::string getCurrentFilename();

    /**
     * This sets the filename of the scene we are currently editing.
     *
     * @param filename The new filename we are editing. Use the value "" to 
     *                 indicate an unnamed file.
     */
    static void setCurrentFilename(const std::string &filename);
    
    static float get3DWidgetSize();
    static void set3DWidgetSize(float size);

    static Aztec::MVector3 getColour(Colours::Colour colour);
    static Aztec::MVector4 getColourWithAlpha(Colours::Colour colour);



    static void addShortcut(Aztec::MKeyEvent::KeyCode code, 
                            Aztec::MShiftState state, 
                            bool pressed, 
                            const std::string &command);
    static void addShortcut(Aztec::MKeyEvent::KeyCode code, 
                            const std::string &command);
    static std::string getShortcut(Aztec::MKeyEvent::KeyCode code, 
                                   Aztec::MShiftState state, 
                                   bool pressed);
    static bool getShortcut(const std::string &command, 
                            Aztec::MKeyEvent::KeyCode &code, 
                            Aztec::MShiftState &state, 
                            bool &pressed);

    static void addFriendlyCommand(const std::string &friendly, const std::string &command, const std::string &category);
    static const std::string& getFriendlyCommand(const std::string &friendly);
    static const std::string& getFriendlyName(const std::string &command);

    class Command {
    public:
      std::string command;
      std::string friendly;
      std::string category;
    };

    typedef std::vector< Command > CommandList;

    static void getFriendlyCommands(CommandList &commands);

    static void clear();

    class Shortcut {
    public:
      Shortcut(Aztec::MKeyEvent::KeyCode code,
               Aztec::MShiftState state,
               bool pressed,
               const std::string &command);
      Shortcut(const Shortcut &src);
      Shortcut();

      Aztec::MKeyEvent::KeyCode code;
      Aztec::MShiftState state;
      bool pressed;
      std::string command;

    };

    static void getShortcuts(std::vector<Shortcut> &shortcuts);

  private:

  };


}




#endif

