#include <Aztec3DPCH.h>
#include <tools/MEdgeTurnTool.h>

// Aztec2 includes
#include <views/Aztec3DView.h>

// AztecLib includes
#include <MSceneObject.h>
#include <MEditableMesh.h>
#include <MUIManager.h>
#include <MScene.h>

namespace AztecGUI {
  
  MEdgeTurnTool::MEdgeTurnTool()
  {
  }

  std::string MEdgeTurnTool::getName() {
    return "toolEdgeTurn";
  }

  int MEdgeTurnTool::drawTool(bool select, const Aztec::MComponentPtr &component)
  {
    return TOOLRESULT_DRAWALL;
  }

  int MEdgeTurnTool::onMouseDown(const Aztec::MMouseEvent &event)
  {
    M3DToolType::onMouseDown(event);

    // Get the opengl view for our event
    AztecGLCanvasPtr GLWnd = AztecGLView::getGLCanvasFor(event.getComponent());
  
    if (GLWnd == NULL) {
      return TOOLRESULT_DRAWNONE;
    }
  
    bool        Changed = false;
    int         EdgeNum = -1;
    Aztec::MVector3 EdgeCentre, EdgeDistance;
    Aztec::MEditableMeshPtr EdgeMesh = NULL;
  
    // check to see if all the mouse buttons are up
    if (!event.getShiftState().leftMouseDown) {
      return TOOLRESULT_DRAWNONE;
    }
  
    // select all the objects in the selection
    Aztec::MUIManager::ComponentType OldMode = Aztec::MUIManager::getComponentMode();
    Aztec::MUIManager::setComponentMode(Aztec::MComponentisedObject::EDGE_TYPE);

    GLWnd->getSelection(event.getX(), event.getY(), m_InputList);
  
    Aztec::MUIManager::setComponentMode(OldMode);
  
    // Go through and select the required objects
    Aztec::MBaseObjectPtr Obj;
  
    for (int i = 0; i < m_InputList.size(); ++i) {
      Aztec::MSelectionItem *SelItem = &m_InputList[i];
    
      if (SelItem->getNumComponents() != 0)
      {
        Aztec::MSceneObjectPtr SelObj;
        Aztec::MEditableMeshPtr MeshObj;
      
        SelObj = AZTEC_CAST(Aztec::MSceneObject, SelItem->getObject());
      
        if (SelObj != NULL)
        {
          MeshObj = AZTEC_CAST(Aztec::MEditableMesh, SelObj->getShapeObject()->convertToMesh());
        
          if (MeshObj == NULL)
            continue;
        
          Aztec::MRay mouseRay;
          Aztec::MMatrix4 objMatInv;

          Aztec::MScene::getGlobalScene()->getWorldTransformMatrix(Aztec::MScene::getGlobalScene()->getObjectList()->findObject(SelObj), objMatInv);
          objMatInv.inverse();
          mouseRay = objMatInv * getDownRay();

          for (int n=0; n<SelItem->getNumComponents(); n++)
          {
            int   Num;
            Aztec::AztecFlags  Mode;
          
            int triangleIndex;
            int            TriEdge;
          
            SelItem->getComponent(n, Mode, Num);
          
            if (Mode != SELECTITEM_EDGE)
              continue;
          
            // Check to see if this is the closest one
          
            if (!MeshObj->getTriFromEdge(Num, triangleIndex, TriEdge))
              continue;
          
            int indexA, indexB;
            Aztec::MVector3 A, B;
            Aztec::MVector3 Centre, Distance;
          
            if (!MeshObj->getVertsFromEdge(Num, &indexA, &indexB)) {
              continue;
            }
          
            A = MeshObj->getVertexPosition(indexA);
            B = MeshObj->getVertexPosition(indexB);
            // calculate the distance from the edge to the cursor
            Centre = 0.5*( B + A );
            Distance = Centre - mouseRay.Org;
          
            if (EdgeNum == -1 || Distance.length2() < EdgeDistance.length2() )
            {
              EdgeMesh = MeshObj;
              EdgeNum = Num;
            
              EdgeDistance = Distance;
              EdgeCentre = Centre;
            }
          
          }
        }
      
      }
    }
  
    if (EdgeMesh != NULL && EdgeNum != -1) {
      EdgeMesh->turnEdge(EdgeNum);
      Changed = true;
    }
  
    m_InputList.clear();
    return Changed;
  }

}

