#include <Aztec3DPCH.h>
#include <tools/CameraTools.h>

// AztecLib includes
#include <ModelGLConst.h>

#include <views/Aztec3DView.h>
#include <views/AztecViewManager.h>

// AztecMain includes
// #include <MDLGlobs.h>

// standard includes
#include <math.h>

namespace AztecGUI {

  using namespace Aztec;

  MCameraTool::MCameraTool() {
    m_OldX = 0;
    m_OldY = 0;
  }

  
  // MToolType methods
  int MCameraTool::onMouseDown(const Aztec::MMouseEvent &event) {
    m_OldX = event.getX();
    m_OldY = event.getY();

    return TOOLRESULT_DRAWNONE;
  }

  //---------------------
  //  MPanOrbitToolType
  //---------------------
  std::string MPanOrbitToolType::getName() {
    return "KToolPanOrbit";
  }

  int MPanOrbitToolType::onMouseMove(const Aztec::MMouseEvent &event)
  {
    MToolType::onMouseMove(event);
  
    if (m_Dragging)
    {
      Aztec3DSceneCanvasPtr GLWnd = AZTEC_CAST(Aztec3DSceneCanvas, AztecGLView::getGLCanvasFor(event.getComponent()));

      if (GLWnd == NULL) {
        return TOOLRESULT_DRAWNONE;
      }
	  if(!GLWnd->isPerspective()){
        return TOOLRESULT_DRAWNONE;
	  }
    
      MVector3 cameraRotation = GLWnd->getCameraRotation();

      if (((int)cameraRotation.x+360)%360 >180) {
        cameraRotation.z -= (float)0.5*(m_OldX - event.getX());
      } else {
        cameraRotation.z += (float)0.5*(m_OldX - event.getX());
      }
    
      cameraRotation.x -= (float)0.5*(m_OldY - event.getY());
    
      if (cameraRotation.x < 0) {
        cameraRotation.x += 360;
      }
      
      if (cameraRotation.z < 0) {
        cameraRotation.z += 360;
      }
    
      if (cameraRotation.x>360) {
        cameraRotation.x -= 360;
      }

      if (cameraRotation.z>360) {
        cameraRotation.z -= 360;
      }

      if ( !GLWnd->isPerspective() ) {
        if (cameraRotation == MVector3(-90,180,0)) {
          AztecView::getViewForComponent(GLWnd)->setName("Top");
        } else if (cameraRotation == MVector3(-90,90,0)) {
          AztecView::getViewForComponent(GLWnd)->setName("Front");
        } else if (cameraRotation == MVector3(0,90,0)) {
          AztecView::getViewForComponent(GLWnd)->setName("Right");
        } else {
          AztecView::getViewForComponent(GLWnd)->setName("User");
        }
      }
    
      GLWnd->setCameraRotation(cameraRotation);
    
      m_OldX = event.getX();
      m_OldY = event.getY();
    
      return TOOLRESULT_DRAWCURRENT;
    }
  
    m_OldX = event.getX();
    m_OldY = event.getY();
  
    return TOOLRESULT_DRAWNONE;
  }

  //---------------------
  //  MPanTrackToolType
  //---------------------
  MPanTrackToolType::MPanTrackToolType() {
  }

  std::string MPanTrackToolType::getName() {
    return "KToolPanTrack";
  }

  int MPanTrackToolType::onMouseMove(const Aztec::MMouseEvent &event)
  {
    MToolType::onMouseMove(event);
  
    if (m_Dragging) {
      Aztec3DSceneCanvasPtr GLWnd = AZTEC_CAST(Aztec3DSceneCanvas, AztecGLView::getGLCanvasFor(event.getComponent()));

      if (GLWnd == NULL) {
        return TOOLRESULT_DRAWNONE;
      }

      MSize2D winsize = GLWnd->getSize();

      MVector3 u, v;

      GLWnd->getScreenVectors(u, v);

      // try something a little different.
      MVector3 diff = ((float)(m_OldX - event.getX())) * u + ((float)(m_OldY - event.getY())) * v;
      

      MVector3 pan = GLWnd->getCameraFocus();
      pan += diff;
      GLWnd->setCameraFocus(pan);
    
      m_OldX = event.getX();
      m_OldY = event.getY();
    
      return TOOLRESULT_DRAWCURRENT;
    }
  
    m_OldX = event.getX();
    m_OldY = event.getY();
  
    return TOOLRESULT_DRAWNONE;
  }



  //--------------------
  //  MPanZoomToolType
  //--------------------
  MPanZoomToolType::MPanZoomToolType() {
  }

  std::string MPanZoomToolType::getName() {
    return "KToolPanZoom";
  }

  int MPanZoomToolType::onMouseMove(const Aztec::MMouseEvent &event)
  {
    MToolType::onMouseMove(event);
  
    if (m_Dragging)
    {
      MVector3       T,N;

      Aztec3DSceneCanvasPtr GLWnd = AZTEC_CAST(Aztec3DSceneCanvas, AztecGLView::getGLCanvasFor(event.getComponent()));

      if (GLWnd == NULL) {
        return TOOLRESULT_DRAWNONE;
      }
      
      if (GLWnd->isPerspective()) {
        float newDist = GLWnd->getDistance() * (pow(1.005, m_OldX - event.getX()));
        if (newDist < 1.0) newDist = 1.0;
        GLWnd->setDistance(newDist);
      } else {
        int diff = m_OldX - event.getX();

        GLWnd->setZoomFactor(GLWnd->getZoomFactor() / pow(1.005, diff));
      }
    
      m_OldX = event.getX();
      m_OldY = event.getY();
    
      return TOOLRESULT_DRAWCURRENT;
    }
  
    m_OldX = event.getX();
    m_OldY = event.getY();
  
    return TOOLRESULT_DRAWNONE;
  }

}
