/**
 * This creats an object of the given type. First it deselects everything in 
 * the scene, then it creates the new object, then selects that new object.
 * The function also takes an optional argument to say what name should be 
 * used to create the object.
 *
 * @param objectType The type of the object to make. Could be 'light', or 
 *        'mesh', or 'group', or something else.
 */
function createObject(objectType) {

  var object;

  // Check to see if we have been passed in the option name argument.
  if (arguments.length > 1) {
    object = Scene.createObject(objectType, arguments[1]);
  } else {
    object = Scene.createObject(objectType);
  }

  if (object != null) {
    Scene.componentModeSet('object');
    Scene.selectNone();
    Scene.selectObject(object);
  }

  return object;
}

