#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/FunctionManager.h>
#include <views/AztecViewManager.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MEditableMesh.h>
#include <MAnimMesh.h>

// Standard includes

namespace AztecGUI {

  int convertToMesh(const StringVector &args, std::string &result) {
    Aztec::MBaseObjectPtr Obj;
    Aztec::MSceneObjectPtr SceneObj;
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    std::vector<Aztec::MNamedObjectPtr> objsToAdd;
    
    scene->getObjectList()->beginIteration();
    
    while (( Obj = scene->getObjectList()->getNext() ) != NULL ) {
      Aztec::MShapeObjectPtr srcShape;
      Aztec::MMeshPtr SrcMesh;
      if (!Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        continue;
      }
      
      SceneObj = AZTEC_CAST(Aztec::MSceneObject, Obj);
      if (SceneObj == NULL) {
        continue;
      }
      
      srcShape = SceneObj->getShapeObject();
      if (srcShape != NULL) {
        SrcMesh = AZTEC_CAST(Aztec::MMesh, srcShape->convertToMesh());
      }
      
      if (SrcMesh == NULL) {
        continue;
      }
      
      
      Aztec::MAnimMeshPtr NewMesh;
      Aztec::MMeshShapePtr meshShape;
      
      NewMesh = new Aztec::MAnimMesh;
      NewMesh->setFrom(SrcMesh);
      
      NewMesh->setName( SceneObj->getName() + "Mesh" );
      
      meshShape = new Aztec::MMeshShape(NewMesh);
      meshShape->setName(SceneObj->getName() + "Shape");
      
      SceneObj->setShapeObject(meshShape);
      
      Aztec::MComponentisedObjectPtr compObj = SceneObj->getComponentObject();
      
      if (compObj != NULL) {
        compObj->setComponentMode(Aztec::MUIManager::getComponentMode());
      }
      
      objsToAdd.push_back(NewMesh);
      objsToAdd.push_back(meshShape);
    }
    scene->getObjectList()->endIteration();
    
    for (int n = 0; n < objsToAdd.size(); ++n) {
      scene->addObject(objsToAdd[n]);
    }
    objsToAdd.clear();
    
    AztecViewManager::redrawAllViews();
    
  return FunctionManager::SUCCEED;
  }


}

