#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/FunctionManager.h>
#include <views/AztecViewManager.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MEditableMesh.h>

// Standard includes

namespace AztecGUI {

  int combineMeshes(const StringVector &args, std::string &result) {
    Aztec::MMeshShapePtr newShapeObject; // this is the new shape object
    Aztec::MEditableMeshPtr newMesh; // this is the new mesh
    std::vector<Aztec::MSceneObjectPtr> srcMeshes;
    Aztec::MSceneObjectPtr masterObj; // this is the object to receive all our meshes
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();

    // get the meshes we will be using as inputs
    {
      Aztec::MBaseObjectPtr obj;
      Aztec::MSceneObjectPtr sceneObj;
      scene->getSelectedObjectList()->beginIteration();
      
      while ((obj = scene->getSelectedObjectList()->getNext()) != NULL) {
        sceneObj = AZTEC_CAST(Aztec::MSceneObject, obj);
        
        // we can only operate on scene objects and those with shape objects
        if (sceneObj == NULL || sceneObj->getShapeObject() == NULL) {
          continue;
        }
        
        // if we haven't got a master object yet, make it so
        if (masterObj == NULL) {
          masterObj = sceneObj;
        }
        
        srcMeshes.push_back(sceneObj);
      }
      
      scene->getSelectedObjectList()->endIteration();
    }
    
    // if we only have one or no input meshes, abort.
    if (srcMeshes.size() <= 1) {
      Aztec::MSystemManager::getInstance()->logOutput("Error: At least two objects with meshes must be selected.");
      return FunctionManager::FAIL;
    }
    
    newShapeObject = new Aztec::MMeshShape();
    newMesh = new Aztec::MEditableMesh();
    
    Aztec::MMatrix4 destWorldInv, srcWorld, transform;
    
    scene->getWorldTransformMatrix( scene->getObjectList()->findObject(masterObj), destWorldInv);
    destWorldInv.inverse();
    for (std::vector<Aztec::MSceneObjectPtr>::iterator it = srcMeshes.begin(); it != srcMeshes.end(); ++it) {
      Aztec::MMeshPtr srcMesh = (*it)->getShapeObject()->convertToMesh();
      Aztec::MVector3 *verts;
      Aztec::MTriangle *tris;
      
      verts = new Aztec::MVector3[srcMesh->getNumVerts()];
      tris = new Aztec::MTriangle[srcMesh->getNumTris()];
      
      scene->getWorldTransformMatrix( scene->getObjectList()->findObject(*it), srcWorld);
      transform = srcWorld * destWorldInv;
      
      // loop over the vertices and triangles
      for (int n = 0; n < srcMesh->getNumVerts(); ++n) {
        verts[n] = transform * srcMesh->getVertexPosition(n);
      }
      
      for (int n = 0; n < srcMesh->getNumTris(); ++n) {
        tris[n].setVertex(0, srcMesh->getTriangleVertex(n, 0));
        tris[n].setVertex(1, srcMesh->getTriangleVertex(n, 1));
        tris[n].setVertex(2, srcMesh->getTriangleVertex(n, 2));
        tris[n].assignEdgeFlag(0, srcMesh->getTriangleEdgeFlag(n, 0));
        tris[n].assignEdgeFlag(1, srcMesh->getTriangleEdgeFlag(n, 1));
        tris[n].assignEdgeFlag(2, srcMesh->getTriangleEdgeFlag(n, 2));
        tris[n].assignFlag(srcMesh->getTriangleFlags(n));
      }
      
      newMesh->addVertsAndTriangles(verts, tris, srcMesh->getNumVerts(), srcMesh->getNumTris());
      
      if (*it != masterObj) {
        scene->deleteObject(*it);
      }
      
      delete[] verts;
      delete[] tris;
    }
    
    newShapeObject->setName(  masterObj->getName() + "Shape" );
    newMesh->setName(  masterObj->getName() + "Mesh" );
    
    scene->addObject(newShapeObject);
    scene->addObject(newMesh);
    
    newShapeObject->setMeshObject(newMesh);
    masterObj->setShapeObject(newShapeObject);
    
    AztecViewManager::redrawAllViews();
    
    return FunctionManager::SUCCEED;
  }


}

