#ifndef GraphViewWnd_Header
#define GraphViewWnd_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <gui/MTreeControl.h>
#include <gui/MContainer.h>

#include <params/MKeyParameter.h>
#include <params/MVector3KeyParameter.h>

#include <controls/GraphComponent.h>
#include <views/ZoomingView.h>
#include <views/AztecView.h>
#include <views/SelectingView.h>
#include <views/DeletingView.h>

#include <map>

#include <MSceneObject.h>

namespace AztecGUI {


  class AztecGraphView : public AztecView, 
                         public ZoomingView,
                         public SelectingView,
                         public DeletingView
  {
  // Construction
  public:
    AztecGraphView();
	  ~AztecGraphView();

    void onSelChanged(const MTreeItemPtr &item);

    // AztecView Methods
    AztecViewPtr createCopy();
    std::string getViewGroup() const;
    MToolTypePtr getSelectTool();
    void drawView();

    // MComponent methods
    void onCreate();

//    virtual DWORD ViewPopupMenu(int x, int y);
//    virtual int HandlePopupCommand(DWORD Cmd);

    GraphComponent* getGraphComponent();

    void doZoomToFit(bool doSelection);

    void deleteSelectedKeys();

    // ZoomingView methods
    void zoomIn();
    void zoomOut();
    void zoomToFitAll();
    void zoomToFitSelected();

    // SelectingView methods
    bool selectParent();
    bool selectChild();
    bool selectSiblingNext();
    bool selectSiblingPrev();
    bool selectNone();
    bool selectAll();
    bool selectInverse();
    bool selectAllChildren();
    bool anythingSelected();
    MVector3 getSelectionCentre();

    // DeletingView methods
    bool deleteSelected();


  private:
    Aztec::MContainerPtr topShelf;

    int shiftingSplitPos;
    int m_SplitPos;
    int splitBarWidth;
    int lastXPos;
  
    MRefCountedPtr<GraphComponent> m_Graph;
    MTreeControlPtr paramListTree;

    // TODO: place this in MKeyParameter.h
    typedef MRefCountedPtr<MKeyParameter> MKeyParameterPtr;

    class TreeItemComparator {
    public:
      // this is actually a less than operator.
      bool operator() (const MTreeItemPtr &lhs, const MTreeItemPtr &rhs) const {
        if (lhs == rhs) return false;

        // sort so NULL's always come before non nulls.
        if (lhs == NULL) return true;
        if (rhs == NULL) return false;

        return ( lhs->compare(rhs) == -1);
      }

    };

    typedef std::map<MTreeItemPtr, MKeyableValuePtr, TreeItemComparator> ItemParamMap;

    std::map<MSceneObjectPtr, MTreeItemPtr> selectedObjects;
    ItemParamMap itemParamMap;
    std::map<MKeyableValuePtr, MTreeItemPtr> paramItemMap;

    typedef std::map<MKeyableValuePtr, MVector3> ParamColourMap;
    ParamColourMap paramColourMap;

    typedef std::set<MKeyableValuePtr> KeyParamSet;
    KeyParamSet selectedParams;

    void updateTreeFromScene();
    void addParameters(MTreeItemPtr parentItem, const MParameterObjectListPtr &paramList);
    void addParameters(MTreeItemPtr parentItem, const MVector3KeyParameterPtr &vectorParam);

    void addParameter(MTreeItemPtr item, const MKeyableValuePtr &param, const Aztec::MVector3 &colour);
    MKeyableValuePtr getParameterFromTree(MTreeItemPtr item);
    MTreeItemPtr getTreeItem(const MKeyableValuePtr &param);

  };


  typedef MRefCountedPtr<AztecGraphView> AztecGraphViewPtr;
}

#endif