#ifndef Aztec3DView_Header
#define Aztec3DView_Header

#include <MRefCountedPtr.h>
#include <views/AztecGLView.h>
#include <views/DeletingView.h>
#include <views/ZoomingView.h>
#include <controls/Aztec3DSceneCanvas.h>

namespace AztecGUI {

  class Aztec3DView : public AztecGLView, public DeletingView, public ZoomingView {
  public:
    typedef enum { Persp, Top, Bottom, Front, Back, Left, Right } ViewType;

    static std::string VIEW_GROUP;

    Aztec3DView(const std::string &viewName, 
                ViewType type = Persp,
                Aztec3DSceneCanvas::ShadingModeEnum = Aztec3DSceneCanvas::ShadingWireframe,
                Aztec3DSceneCanvas::TextureModeEnum = Aztec3DSceneCanvas::TextureNearest);
    ~Aztec3DView();

    Aztec3DSceneCanvasPtr get3DCanvas();

    void setViewType(ViewType type, bool changeName = true);

    void make3DMenu(const Aztec::MMenuShellPtr &menu, bool atStart);

    // DeletingView methods
    bool deleteSelected();

    // ZoomingView methods
    void zoomIn();
    void zoomOut();
    void zoomToFitAll();
    void zoomToFitSelected();

    // AztecGLView methods
    AztecGLCanvasPtr getCanvas();

    // AztecView methods
    AztecViewPtr createCopy();
    void drawView();
    std::string getViewGroup() const;
    void constructContextMenu(const Aztec::MMenuShellPtr &menu, const Aztec::MMouseEvent &event);

    // MComponent methods
    void onCreate();

  protected:
    Aztec3DSceneCanvasPtr canvas;
    ViewType viewType;
    static void updateCanvasFromViewType(const Aztec3DSceneCanvasPtr &canvas, 
                                         ViewType type);

    void zoomToFit(bool selected);
  };


  typedef Aztec::MRefCountedPtr<Aztec3DView> Aztec3DViewPtr;
}

#endif

