#ifndef MGLScaleTool_Header
#define MGLScaleTool_Header

#include <tools/MXYZToolType.h>

namespace AztecGUI {

  /**
   * This tool provides the user with a 3D widget that the user can grad to scale objects in the scene.
   * There are four widgeets:
   * <UL>
   * <LI>1: Scales the object in the X direction
   * <LI>2: Scales the object in the Y direction
   * <LI>3: Scales the object in the Z direction
   * <LI>4: Scales the object uniformly in all XYZ directions.
   * </UL>
   */
  class MGLScaleToolType : public MXYZToolType {
  public:
     MGLScaleToolType();

     // MToolType methods
     std::string getName();
     int drawTool(bool Select, const Aztec::MComponentPtr &comp);
     int onMouseDown(const Aztec::MMouseEvent &event);
     int onMouseUp(const Aztec::MMouseEvent &event);
     int onMouseMove(const Aztec::MMouseEvent &event);
     int getDefaultManip();
  protected:

    /// Used to keep track of how much we are scaling the curent selection.
    Aztec::MVector3 m_ScaleVec;

    /// Stores the center of the current selection to scale around.
    Aztec::MVector3 m_PivotPoint;

    /// Stores the vector in 3D space that points to the right of the screen. Used to measure how far the user has moved the mouse.
    Aztec::MVector3 m_RightVec;
  };

}
#endif